/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.gameplay;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.WindConfig;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class WindPhysics {
    private WindPhysics() {
    }

    public static void onServerTick(ServerLevel level) {
        for (ServerPlayer p : level.players()) {
            WindPhysics.applyIfStrong(level, (LivingEntity)p);
        }
    }

    private static void applyIfStrong(ServerLevel lvl, LivingEntity e) {
        BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(lvl, e.blockPosition());
        WindVector.WindSample w = WindVector.getOrFallback(key);
        if (w.speedMps() < WindConfig.pushThresholdMps()) {
            return;
        }
        Vec3 push = WindPhysics.dirToVec(w.directionDeg()).scale((double)w.speedMps() * WindPhysics.pushScale(e));
        e.push(push.x, 0.0, push.z);
        e.hurtMarked = true;
    }

    private static Vec3 dirToVec(float deg) {
        double rad = Math.toRadians(deg);
        return new Vec3(-Math.sin(rad), 0.0, Math.cos(rad));
    }

    private static double pushScale(LivingEntity e) {
        return e instanceof ServerPlayer ? (double)WindConfig.playerPushScale() : (double)WindConfig.entityPushScale();
    }
}

