/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.hurricane;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneCategory;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneInstance;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HurricaneManager {
    private static final List<HurricaneInstance> ACTIVE_HURRICANES = new ArrayList<HurricaneInstance>();

    public static void spawnServer(ServerLevel level, Vec3 pos, float radius, WindVector wind, HurricaneCategory category) {
        ACTIVE_HURRICANES.add(new HurricaneInstance(pos, radius, wind, category));
    }

    public static void tick(ServerLevel level) {
        ACTIVE_HURRICANES.removeIf(h -> h.getLifetimeSeconds() > 1200.0f);
        for (HurricaneInstance hurricane : ACTIVE_HURRICANES) {
            float speed = hurricane.wind.baseSpeed() * 0.01f;
            hurricane.position = hurricane.position.add(Math.cos(hurricane.wind.angleRadians()) * (double)speed, 0.0, Math.sin(hurricane.wind.angleRadians()) * (double)speed);
            hurricane.tick((Level)level);
        }
    }

    public static List<HurricaneInstance> getActiveHurricanes() {
        return Collections.unmodifiableList(ACTIVE_HURRICANES);
    }

    public static void clearHurricanes() {
        ACTIVE_HURRICANES.clear();
    }

    public static void removeHurricane(HurricaneInstance hurricane) {
        ACTIVE_HURRICANES.remove(hurricane);
    }
}

