/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.storm;

import java.util.Random;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import sereneseasons.api.season.Season;

public class StormGenerator {
    private static final float DEFAULT_MIN = 0.0f;
    private static final float DEFAULT_MAX = 1.0f;

    public static float[][] generateWeeklyStormProfile(BiomeInstanceKey biome, float[][] temperature, float[][] humidity, float[][] pressure, WindVector[] wind, Season season) {
        float[][] stormWeek = new float[7][2];
        BlockPos pos = biome.samplePos();
        for (int day = 0; day < 7; ++day) {
            float windStrength;
            float stormScore = 0.0f;
            float tempAvg = (temperature[day][0] + temperature[day][1]) / 2.0f;
            float tempDelta = temperature[day][1] - temperature[day][0];
            float rhAvg = (humidity[day][0] + humidity[day][1]) / 2.0f;
            float pressureAvg = (pressure[day][0] + pressure[day][1]) / 2.0f;
            float f = windStrength = wind != null && wind.length > day ? wind[day].baseSpeed() : 0.0f;
            if (tempAvg > 24.0f) {
                stormScore += 0.1f;
            }
            if (tempAvg > 30.0f) {
                stormScore += 0.15f;
            }
            if (pressureAvg < 1008.0f) {
                stormScore += 0.15f;
            }
            if (pressureAvg < 1000.0f) {
                stormScore += 0.25f;
            }
            if (pressureAvg < 990.0f) {
                stormScore += 0.2f;
            }
            if (rhAvg > 0.6f) {
                stormScore += 0.15f;
            }
            if (rhAvg > 0.8f) {
                stormScore += 0.15f;
            }
            if (tempDelta > 8.0f) {
                stormScore += 0.15f;
            }
            if (windStrength > 10.0f) {
                stormScore += 0.1f;
            }
            if (windStrength > 14.0f) {
                stormScore += 0.1f;
            }
            float seasonalMultiplier = StormGenerator.getSeasonalStormMultiplier(season);
            stormScore *= seasonalMultiplier;
            long seed = ProjectAtmosphere.seed ^ pos.asLong() ^ (long)biome.hashCode() ^ (long)day;
            Random rand = new Random(seed);
            stormScore += (rand.nextFloat() - 0.5f) * 0.15f;
            float baseMin = StormGenerator.getSeasonalStormMin(season);
            float baseMax = StormGenerator.getSeasonalStormMax(season);
            float amplified = stormScore * 1.15f;
            float minJitter = (rand.nextFloat() - 0.5f) * 0.1f;
            float dailyMin = StormGenerator.clamp(baseMin + minJitter, 0.0f, baseMax);
            float dailyMax = StormGenerator.clamp(amplified, dailyMin, baseMax);
            if (dailyMax < 0.25f && rand.nextFloat() < 0.2f) {
                dailyMin = 0.0f;
                dailyMax = 0.0f;
            } else if (dailyMax < 0.45f && rand.nextFloat() < 0.25f) {
                dailyMin = Math.max(dailyMin, 0.18f);
                dailyMax = Math.max(dailyMax, 0.3f);
            }
            stormWeek[day][0] = dailyMin;
            stormWeek[day][1] = dailyMax;
        }
        return stormWeek;
    }

    private static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    private static float getSeasonalStormMultiplier(Season season) {
        return switch (season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> 1.1f;
            case Season.SUMMER -> 1.4f;
            case Season.AUTUMN -> 1.6f;
            case Season.WINTER -> 0.8f;
        };
    }

    private static float getSeasonalStormMin(Season season) {
        return switch (season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> 0.18f;
            case Season.SUMMER -> 0.12f;
            case Season.AUTUMN -> 0.0f;
            case Season.WINTER -> 0.08f;
        };
    }

    private static float getSeasonalStormMax(Season currentSeason) {
        return switch (currentSeason) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> 0.9f;
            case Season.SUMMER, Season.AUTUMN -> 1.0f;
            case Season.WINTER -> 0.7f;
        };
    }
}

