/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class WindStreakParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected WindStreakParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.gravity = 0.0f;
        this.friction = 0.99f;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.lifetime = 20 + this.random.nextInt(20);
        this.setSize(0.05f, 0.2f);
        try {
            this.setSpriteFromAge(sprites);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.alpha = 0.0f;
    }

    public void tick() {
        super.tick();
        try {
            this.setSpriteFromAge(this.sprites);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.age < this.lifetime / 4) {
            this.alpha = (float)this.age / ((float)this.lifetime / 4.0f);
        } else if (this.age > this.lifetime * 3 / 4) {
            this.alpha = (float)(this.lifetime - this.age) / ((float)this.lifetime / 4.0f);
        }
        this.xd += (double)((this.random.nextFloat() - 0.5f) * 0.001f);
        this.zd += (double)((this.random.nextFloat() - 0.5f) * 0.001f);
    }

    public float getQuadSize(float partialTicks) {
        return 0.3f + (float)this.age / (float)this.lifetime * 0.2f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WindStreakParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

