/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere;

import dev.nonamecrackers2.simpleclouds.api.SimpleCloudsAPI;
import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.Objects;
import net.Gabou.projectatmosphere.ClientSystemProfile;
import net.Gabou.projectatmosphere.ServerSystemProfile;
import net.Gabou.projectatmosphere.client.ClientTickHandler;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.event.BiomeChangeManager;
import net.Gabou.projectatmosphere.event.EventHandler;
import net.Gabou.projectatmosphere.event.SeasonTracker;
import net.Gabou.projectatmosphere.event.SimpleCloudsEventListener;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneCommand;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempUserConfig;
import net.Gabou.projectatmosphere.modules.tornado.TornadoCommand;
import net.Gabou.projectatmosphere.modules.tornado.TornadoDebug;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.registry.ClientOnlyRegistrar;
import net.Gabou.projectatmosphere.registry.ModBlocks;
import net.Gabou.projectatmosphere.registry.ModItems;
import net.Gabou.projectatmosphere.registry.ModParticles;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.Gabou.projectatmosphere.registry.ModTabs;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.CloudSpawnScheduler;
import net.Gabou.projectatmosphere.util.TickCounter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectatmosphere")
@EventBusSubscriber(modid="projectatmosphere")
public class ProjectAtmosphere {
    public static final float DEFAULT_REGION_RADIUS = 700.0f;
    public static final int DEFAULT_RADIUS = 10000;
    public static long seed;
    public static final String MODID = "projectatmosphere";
    public static final Logger LOGGER;

    public ProjectAtmosphere(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Project Atmosphere is loading!");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmoCommonConfig.COMMON_SPEC);
        CompatHandler.init();
        SimpleCloudsEventListener.register(NeoForge.EVENT_BUS);
        SimpleCloudsConstants.SPAWN_RADIUS = Math.round(114.28571f * (float)ForecastGenerator.MAX_POSITIONS_PER_BIOME);
        this.registerListenersAndRegistries(modEventBus);
    }

    private void registerListenersAndRegistries(IEventBus modEventBus) {
        NetworkHandler.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(event -> this.clientSetup((FMLClientSetupEvent)event, modEventBus));
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        ModParticles.register(modEventBus);
        ModTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModBlocks.REGISTRY.register(modEventBus);
        CloudSpawnScheduler.register(NeoForge.EVENT_BUS);
        SeasonTracker.register();
        NeoForge.EVENT_BUS.register(BiomeChangeManager.class);
        NeoForge.EVENT_BUS.register(EventHandler.class);
        NeoForge.EVENT_BUS.addListener(TickCounter::onServerTick);
        NeoForge.EVENT_BUS.addListener(TornadoDebug::register);
        NeoForge.EVENT_BUS.addListener(TornadoCommand::register);
        NeoForge.EVENT_BUS.addListener(HurricaneCommand::register);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel world = event.getServer().getLevel(ServerLevel.OVERWORLD);
        if (world != null) {
            if (!world.isClientSide) {
                AsyncAtmosphereService.init(false);
                SimpleCloudsCompat.init(world);
                seed = world.getSeed();
            } else {
                AsyncAtmosphereService.init(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.overworld();
        AtmosphereManager.onServerStarting(overworld);
        LOGGER.info("BiomeSampler initialized with live biome source.");
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        ServerLevel world;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (world = Objects.requireNonNull((player = (ServerPlayer)player2).getServer()).getLevel(ServerLevel.OVERWORLD)) != null) {
            AtmosphereManager.onPlayerLogout(world, player);
        }
    }

    private void initModules() {
        ProjectAtmosphere.isSereneLoaded();
        ProjectAtmosphere.sendInfo();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AsyncAtmosphereService.shutdown();
        ServerLevel world = event.getServer().getLevel(ServerLevel.OVERWORLD);
        if (world != null) {
            AtmosphereManager.onServerStopping(world);
            seed = 0L;
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setting up Project Atmosphere (Common)");
        this.initModules();
        TornadoProbabilityManager.init();
        event.enqueueWork(() -> {
            SimpleCloudsAPI.getApi().getHooks().setExternalWeatherControl(true);
            BiomeTempUserConfig.load();
        });
    }

    private void clientSetup(FMLClientSetupEvent event, IEventBus modEventBus) {
        event.enqueueWork(() -> {
            LOGGER.info("Setting up Project Atmosphere (Client)");
            NeoForge.EVENT_BUS.register(ClientTickHandler.class);
            ClientOnlyRegistrar.registerClient(modEventBus);
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        AtmosphereManager.onRegisterCommands(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        LOGGER.info("Player logged in!");
        AtmosphereManager.onPlayerLogin(player2.getServer().getLevel(ServerLevel.OVERWORLD), player2);
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent event) {
    }

    private static void sendInfo() {
        LOGGER.info("All modules subsystems have been initialized (Serene Seasons detected).");
    }

    private static void isSereneLoaded() {
        if (!ModList.get().isLoaded("sereneseasons")) {
            LOGGER.info("Serene Seasons is not found\u2014skipping all modules subsystems.");
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }

    public static abstract class SystemProfile {
        public final int cpuCount = Runtime.getRuntime().availableProcessors();
        public final long maxMemoryMB = Runtime.getRuntime().maxMemory() / 0x100000L;

        public boolean isLowSpecCPU() {
            return this.cpuCount <= 4;
        }

        public boolean isLowMemory() {
            return this.maxMemoryMB <= 2048L;
        }

        public boolean isLowSpec() {
            return this.isLowSpecCPU() || this.isLowMemory() || !this.isGoodEnoughGPU();
        }

        public abstract boolean isGoodEnoughGPU();

        public abstract String getGPUName();

        public static SystemProfile create(boolean isClient) {
            return isClient ? new ClientSystemProfile() : new ServerSystemProfile();
        }
    }
}

