/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.async;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;

public final class BiomeSampler {
    private final BiomeSource biomeSource;
    private final Climate.Sampler sampler;

    public BiomeSampler(long seed, RegistryAccess registryAccess, BiomeSource biomeSource) {
        Holder.Reference settingsHolder = registryAccess.registryOrThrow(Registries.NOISE_SETTINGS).getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD);
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)settingsHolder.value();
        HolderLookup.RegistryLookup noiseParams = registryAccess.lookupOrThrow(Registries.NOISE);
        RandomState randomState = RandomState.create((NoiseGeneratorSettings)settings, (HolderGetter)noiseParams, (long)seed);
        this.sampler = randomState.sampler();
        this.biomeSource = biomeSource;
    }

    public ResourceLocation getBiomeId(int x, int y, int z) {
        int qx = x >> 2;
        int qy = y >> 2;
        int qz = z >> 2;
        Holder biome = this.biomeSource.getNoiseBiome(qx, qy, qz, this.sampler);
        return biome.unwrapKey().map(ResourceKey::location).orElse(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains"));
    }
}

