/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.nonamecrackers2.simpleclouds.common.config.SimpleCloudsConfig;
import net.Gabou.projectatmosphere.client.MyShaders;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoLevel;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.particles.DebrisParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TornadoRenderHandler {
    private static final ResourceLocation NOISE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/noise.png");
    private static final ResourceLocation TORNADO_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/base.png");
    private static final ResourceLocation FLOWMAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/flowmap.png");
    private static final ResourceLocation NORMALMAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectatmosphere", (String)"textures/effects/tornado_normal.png");
    private static final float SPAWN_DESCENT_DURATION = 10.0f;

    public static void renderTornado(PoseStack stack, double tornadoX, double tornadoY, double tornadoZ, float twistSpeed, ClientLevel level, Camera camera, Minecraft minecraft, TornadoInstance tornado) {
        BufferBuilder buffer;
        Uniform scaleUniform;
        Uniform flowIntensity;
        Uniform coreUniform;
        Uniform dustUniform;
        Uniform heightUniform;
        Uniform topRadiusUniform;
        Uniform baseRadiusUniform;
        Uniform twistUniform;
        Uniform timeUniform;
        Uniform projMat;
        ShaderInstance shader = MyShaders.TORNADO;
        if (shader == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TORNADO_TEXTURE);
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)FLOWMAP_TEXTURE);
        RenderSystem.setShaderTexture((int)2, (ResourceLocation)NORMALMAP_TEXTURE);
        RenderSystem.setShaderTexture((int)3, (ResourceLocation)NOISE_TEXTURE);
        RenderSystem.setShader(() -> shader);
        shader.apply();
        int segments = 64;
        int rings = 128;
        float baseRadius = 20.0f;
        float topRadius = 5.0f;
        float height = 356.0f;
        float coneStart = 0.5f;
        float coneFactor = 3.5f;
        stack.pushPose();
        stack.translate(tornadoX, tornadoY, tornadoZ);
        Matrix4f matrix = stack.last().pose();
        Uniform modelView = shader.getUniform("ModelViewMat");
        if (modelView != null) {
            modelView.set(matrix);
        }
        if ((projMat = shader.getUniform("ProjMat")) != null) {
            projMat.set(RenderSystem.getProjectionMatrix());
        }
        if ((timeUniform = shader.getUniform("Time")) != null) {
            timeUniform.set(TornadoManager.getShaderTime());
        }
        if ((twistUniform = shader.getUniform("TwistSpeed")) != null) {
            twistUniform.set(twistSpeed);
        }
        if ((baseRadiusUniform = shader.getUniform("BaseRadius")) != null) {
            baseRadiusUniform.set(baseRadius);
        }
        if ((topRadiusUniform = shader.getUniform("TopRadius")) != null) {
            topRadiusUniform.set(topRadius);
        }
        if ((heightUniform = shader.getUniform("Height")) != null) {
            heightUniform.set(height);
        }
        if ((dustUniform = shader.getUniform("DustIntensity")) != null) {
            dustUniform.set(0.5f);
        }
        if ((coreUniform = shader.getUniform("CoreTightness")) != null) {
            coreUniform.set(0.2f);
        }
        if ((flowIntensity = shader.getUniform("FlowIntensity")) != null) {
            flowIntensity.set(0.1f);
        }
        if ((scaleUniform = shader.getUniform("Scale")) != null) {
            float scale = (float)(tornado.getLevel().getBaseDamage() / TornadoLevel.F1.getBaseDamage());
            scaleUniform.set(scale);
        }
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        float sunAngle = level.getTimeOfDay(partialTicks);
        float angle = sunAngle * ((float)Math.PI * 2);
        float xLight = Mth.cos((float)angle);
        float yLight = Mth.sin((float)angle);
        float zLight = 0.2f;
        float length = Mth.sqrt((float)(xLight * xLight + yLight * yLight + zLight * zLight));
        xLight /= length;
        yLight /= length;
        zLight /= length;
        Uniform lightX = shader.getUniform("LightDirX");
        Uniform lightY = shader.getUniform("LightDirY");
        Uniform lightZ = shader.getUniform("LightDirZ");
        if (lightX != null) {
            lightX.set(xLight);
        }
        if (lightY != null) {
            lightY.set(yLight);
        }
        if (lightZ != null) {
            lightZ.set(zLight);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder consumer = buffer = tess.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX);
        float windSpeed = tornado.wind.gustSpeed();
        float windAngleDeg = tornado.wind.angleRadians();
        float windAngleRad = (float)Math.toRadians(windAngleDeg);
        double windX = Math.cos(windAngleRad) * (double)windSpeed;
        double windZ = Math.sin(windAngleRad) * (double)windSpeed;
        Vec3 horizontalWind = new Vec3(windX, 5.0, windZ);
        float spawnProgress = Mth.clamp((float)(tornado.getLifetimeSeconds() / 10.0f), (float)0.0f, (float)1.0f);
        float cutoffY = height * (1.0f - spawnProgress);
        float time = TornadoManager.getShaderTime();
        for (int i = rings - 1; i >= 0; --i) {
            float y0 = (float)i * (height / (float)rings);
            float y1 = (float)(i + 1) * (height / (float)rings);
            if (y1 < cutoffY) break;
            if (y0 < cutoffY) {
                y0 = cutoffY;
            }
            float t0 = y0 / height;
            float t1 = y1 / height;
            for (int j = 0; j < segments; ++j) {
                float u0 = (float)j / (float)segments;
                float u1 = ((float)j + 1.0f) / (float)segments;
                float U_EPS = 1.0E-6f;
                float u0s = j == 0 ? u0 + 1.0E-6f : u0;
                float u1s = j == segments - 1 ? 0.999999f : u1;
                float twist = 10.995574f;
                float angleOffset0 = twist * (1.0f - t0);
                float angleOffset1 = twist * (1.0f - t1);
                float angle0_0 = (float)(Math.PI * 2 * (double)u0 + (double)angleOffset0);
                float angle0_1 = (float)(Math.PI * 2 * (double)u1 + (double)angleOffset0);
                float angle1_0 = (float)(Math.PI * 2 * (double)u0 + (double)angleOffset1);
                float angle1_1 = (float)(Math.PI * 2 * (double)u1 + (double)angleOffset1);
                float x00 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_0, time) * (float)Math.cos(angle0_0);
                float z00 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_0, time) * (float)Math.sin(angle0_0);
                float x01 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_1, time) * (float)Math.cos(angle0_1);
                float z01 = TornadoRenderHandler.tornadoShapeRadius(y0, angle0_1, time) * (float)Math.sin(angle0_1);
                float x10 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_0, time) * (float)Math.cos(angle1_0);
                float z10 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_0, time) * (float)Math.sin(angle1_0);
                float x11 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_1, time) * (float)Math.cos(angle1_1);
                float z11 = TornadoRenderHandler.tornadoShapeRadius(y1, angle1_1, time) * (float)Math.sin(angle1_1);
                float wiggleFreq = 5.0f;
                float wiggleAmp = 0.5f;
                x00 = (float)((double)x00 + Math.sin(y0 * 0.1f + angle0_0 * wiggleFreq) * (double)wiggleAmp);
                z00 = (float)((double)z00 + Math.cos(y0 * 0.1f + angle0_0 * wiggleFreq) * (double)wiggleAmp);
                x01 = (float)((double)x01 + Math.sin(y0 * 0.1f + angle0_1 * wiggleFreq) * (double)wiggleAmp);
                z01 = (float)((double)z01 + Math.cos(y0 * 0.1f + angle0_1 * wiggleFreq) * (double)wiggleAmp);
                x10 = (float)((double)x10 + Math.sin(y1 * 0.1f + angle1_0 * wiggleFreq) * (double)wiggleAmp);
                z10 = (float)((double)z10 + Math.cos(y1 * 0.1f + angle1_0 * wiggleFreq) * (double)wiggleAmp);
                x11 = (float)((double)x11 + Math.sin(y1 * 0.1f + angle1_1 * wiggleFreq) * (double)wiggleAmp);
                z11 = (float)((double)z11 + Math.cos(y1 * 0.1f + angle1_1 * wiggleFreq) * (double)wiggleAmp);
                float epsilon = 1.0E-4f;
                float v0 = (y0 + epsilon) / height;
                float v1 = (y1 - epsilon) / height;
                float bendScale = 1.5f;
                float bendFactor0 = y0 / height * bendScale * windSpeed;
                float bendFactor1 = y1 / height * bendScale * windSpeed;
                float offsetX0 = (float)horizontalWind.x * bendFactor0;
                float offsetZ0 = (float)horizontalWind.z * bendFactor0;
                float offsetX1 = (float)horizontalWind.x * bendFactor1;
                float offsetZ1 = (float)horizontalWind.z * bendFactor1;
                x01 += offsetX0;
                z01 += offsetZ0;
                consumer.addVertex(matrix, x00 += offsetX0, y0, z00 += offsetZ0).setUv(u0s, v0);
                consumer.addVertex(matrix, x10 += offsetX1, y1, z10 += offsetZ1).setUv(u0s, v1);
                consumer.addVertex(matrix, x11 += offsetX1, y1, z11 += offsetZ1).setUv(u1s, v1);
                consumer.addVertex(matrix, x00, y0, z00).setUv(u0s, v0);
                consumer.addVertex(matrix, x11, y1, z11).setUv(u1s, v1);
                consumer.addVertex(matrix, x01, y0, z01).setUv(u1s, v0);
            }
        }
        int bowlRings = 24;
        float bowlHeight = 12.0f;
        float angleDeg = 18.0f;
        float targetTopR = (topRadius -= 3.0f) * 1.6f;
        float factor = 1.6f;
        float p = 1.0f;
        float flareSlope = 0.3f;
        float maxBowlRadius = topRadius + flareSlope * bowlHeight;
        for (int i = 0; i < bowlRings; ++i) {
            float t0 = (float)i / (float)bowlRings;
            float t1 = ((float)i + 1.0f) / (float)bowlRings;
            float y0 = height + t0 * bowlHeight;
            float y1 = height + t1 * bowlHeight;
            float r0 = TornadoRenderHandler.coneRadiusByAngle(y0, height, topRadius, bowlHeight, angleDeg, p);
            float r1 = TornadoRenderHandler.coneRadiusByAngle(y1, height, topRadius, bowlHeight, angleDeg, p);
            float twist = 10.995574f;
            float aOff0 = twist * (1.0f - Math.min(1.0f, y0 / height));
            float aOff1 = twist * (1.0f - Math.min(1.0f, y1 / height));
            for (int j = 0; j < segments; ++j) {
                float u0 = (float)j / (float)segments;
                float u1 = ((float)j + 1.0f) / (float)segments;
                float a00 = (float)(Math.PI * 2 * (double)u0 + (double)aOff0);
                float a01 = (float)(Math.PI * 2 * (double)u1 + (double)aOff0);
                float a10 = (float)(Math.PI * 2 * (double)u0 + (double)aOff1);
                float a11 = (float)(Math.PI * 2 * (double)u1 + (double)aOff1);
                float x00 = r0 * (float)Math.cos(a00);
                float z00 = r0 * (float)Math.sin(a00);
                float x01 = r0 * (float)Math.cos(a01);
                float z01 = r0 * (float)Math.sin(a01);
                float x10 = r1 * (float)Math.cos(a10);
                float z10 = r1 * (float)Math.sin(a10);
                float x11 = r1 * (float)Math.cos(a11);
                float z11 = r1 * (float)Math.sin(a11);
                float b0 = y0 / (height + bowlHeight) * 1.5f * windSpeed;
                float b1 = y1 / (height + bowlHeight) * 1.5f * windSpeed;
                x00 += (float)horizontalWind.x * b0;
                z00 += (float)horizontalWind.z * b0;
                x01 += (float)horizontalWind.x * b0;
                z01 += (float)horizontalWind.z * b0;
                x10 += (float)horizontalWind.x * b1;
                z10 += (float)horizontalWind.z * b1;
                x11 += (float)horizontalWind.x * b1;
                z11 += (float)horizontalWind.z * b1;
                float epsilon = 1.0E-4f;
                float v0 = Math.min(1.0f - epsilon, y0 / height);
                float v1 = Math.min(1.0f - epsilon, y1 / height);
                consumer.addVertex(matrix, x00, y0, z00).setUv(u0, v0);
                consumer.addVertex(matrix, x10, y1, z10).setUv(u0, v1);
                consumer.addVertex(matrix, x11, y1, z11).setUv(u1, v1);
                consumer.addVertex(matrix, x00, y0, z00).setUv(u0, v0);
                consumer.addVertex(matrix, x11, y1, z11).setUv(u1, v1);
                consumer.addVertex(matrix, x01, y0, z01).setUv(u1, v0);
            }
        }
        MeshData mesh = buffer.build();
        BufferUploader.drawWithShader((MeshData)mesh);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        stack.popPose();
    }

    private static float tornadoShapeRadius(float y, float angle, float time) {
        float yAdj = y + 45.0f;
        float zcurve = (float)Math.pow(yAdj, 1.5) * 0.03f;
        float base = zcurve + 5.5f;
        float scale = Mth.clamp((float)(zcurve * 0.2f), (float)0.1f, (float)1.0f);
        float radius = base + scale * Mth.sin((float)(time - Mth.sqrt((float)yAdj) + angle)) * 5.0f;
        float ridgedNoise = 1.0f - 2.0f * Math.abs(Mth.sin((float)(time * 1.5f + 0.1f * yAdj + angle)));
        return radius -= ridgedNoise * 1.2f;
    }

    public static void spawnDebrisParticles(TornadoInstance tornado, ClientLevel level) {
        for (int i = 0; i < 10; ++i) {
            double maxRadius = 16.0;
            double radius = Math.sqrt(level.random.nextDouble()) * maxRadius;
            double height = level.random.nextDouble() * (double)((Integer)SimpleCloudsConfig.CLIENT.cloudHeight.get()).intValue();
            float angularSpeed = 4.0f;
            level.addParticle((ParticleOptions)new DebrisParticleData(tornado, radius, height, angularSpeed), tornado.position.x, tornado.position.y, tornado.position.z, 0.0, 0.01, 0.0);
        }
    }

    static float coneRadiusByAngle(float y, float seamY, float topRadius, float bowlHeight, float angleDeg, float p) {
        float t = Mth.clamp((float)((y - seamY) / bowlHeight), (float)0.0f, (float)1.0f);
        float slope = (float)Math.tan(Math.toRadians(angleDeg));
        float targetR = topRadius + slope * bowlHeight;
        float linear = topRadius + (targetR - topRadius) * t;
        return p == 1.0f ? linear : topRadius + (targetR - topRadius) * (float)Math.pow(t, p);
    }
}

