/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client.screen;

import com.Gabou.sereneseasonsplus.util.IScreen;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.util.Iterator;
import java.util.Random;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneInstance;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class WeatherRadarScreen
extends Screen {
    private static final int MAP_SIZE = 256;
    private static final int RANGE = 2048;
    private static final int FORECAST_TICKS = 600;
    private static final int MAX_RENDER_RADIUS_PX = 24;
    private static final int MIN_RENDER_RADIUS_PX = 1;
    private static final int MAX_BLOBS_PER_REGION = 3;
    private final Player player;
    private final CloudManager<?> cloudManager;
    private float zoom = 1.0f;

    public WeatherRadarScreen(Player player) {
        super((Component)Component.translatable((String)"item.projectatmosphere.weather_radar"));
        this.player = player;
        this.cloudManager = CloudManager.get((Level)player.level());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int color;
        int y;
        int x;
        float dz;
        int left = (this.width - 256) / 2;
        int top = (this.height - 256) / 2;
        float scale = 8.0f / Math.max(0.25f, this.zoom);
        guiGraphics.fill(left, top, left + 256, top + 256, -16777216);
        if (this.cloudManager != null) {
            Iterator<HurricaneInstance> clouds = this.cloudManager.getClouds();
            Iterator iterator = clouds.iterator();
            while (iterator.hasNext()) {
                CloudRegion region = (CloudRegion)iterator.next();
                float dx = (region.getWorldX() - (float)this.player.getX()) / scale;
                float dz2 = (region.getWorldZ() - (float)this.player.getZ()) / scale;
                int r = Math.max(1, Math.round(region.getWorldRadius() / scale));
                r = Math.min(24, r);
                int x2 = left + 128 + Math.round(dx);
                int y2 = top + 128 + Math.round(dz2);
                int severity = CloudLibrary.getSeverityFromRessourceLocation(region.getCloudTypeId());
                String cloudId = region.getCloudTypeId().getPath();
                boolean thunder = CloudLibrary.isThunderCloud(cloudId);
                int colorRgb = WeatherRadarScreen.classifyColor(cloudId, severity, thunder);
                int alpha = Math.max(80, Math.min(224, 32 + Math.round((float)severity / 7.0f * 207.0f)));
                long seed = (long)(region.getWorldX() * 31.0f) ^ (long)(region.getWorldZ() * 131.0f) ^ (long)cloudId.hashCode();
                Random rand = new Random(seed);
                int blobs = 1 + rand.nextInt(3);
                for (int i = 0; i < blobs; ++i) {
                    float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                    float dist = rand.nextFloat() * ((float)r * 0.4f);
                    int bx = x2 + Math.round((float)Math.cos(angle) * dist);
                    int by = y2 + Math.round((float)Math.sin(angle) * dist);
                    float scaleBlob = 0.6f + rand.nextFloat() * 0.6f;
                    int rx = Math.max(1, Math.round((float)r * scaleBlob));
                    int ry = Math.max(1, Math.round((float)r * (0.7f + rand.nextFloat() * 0.6f)));
                    int jittered = WeatherRadarScreen.jitterColor(rand, colorRgb, thunder ? 28 : 18);
                    int localAlpha = WeatherRadarScreen.clamp(64, 224, alpha + rand.nextInt(33) - 16);
                    int color2 = localAlpha << 24 | jittered;
                    this.fillEllipse(guiGraphics, bx, by, rx, ry, color2);
                }
                Vec2 dir = region.getMovementDirection();
                float speed = region.getMaxSpeed();
                float futureX = region.getWorldX() + dir.x * speed * 600.0f;
                float futureZ = region.getWorldZ() + dir.y * speed * 600.0f;
                float fdx = (futureX - (float)this.player.getX()) / scale;
                float fdz = (futureZ - (float)this.player.getZ()) / scale;
                int fx = left + 128 + Math.round(fdx);
                int fy = top + 128 + Math.round(fdz);
                int forecastColor = alpha / 2 << 24 | colorRgb;
                this.fillEllipse(guiGraphics, fx, fy, Math.max(1, r / 2), Math.max(1, r / 3), forecastColor);
            }
        }
        for (TornadoInstance t : TornadoManager.getActiveTornadoes()) {
            float dx = (float)((t.position.x - this.player.getX()) / (double)scale);
            dz = (float)((t.position.z - this.player.getZ()) / (double)scale);
            int r = Math.max(2, Math.round(t.radius / scale));
            x = left + 128 + Math.round(dx);
            y = top + 128 + Math.round(dz);
            color = -1065353088;
            this.fillEllipse(guiGraphics, x, y, Math.max(2, r), Math.max(2, (int)((float)r * 0.7f)), color);
        }
        for (HurricaneInstance h : HurricaneManager.getActiveHurricanes()) {
            float dx = (float)((h.position.x - this.player.getX()) / (double)scale);
            dz = (float)((h.position.z - this.player.getZ()) / (double)scale);
            int r = Math.max(3, Math.round(h.radius / scale));
            x = left + 128 + Math.round(dx);
            y = top + 128 + Math.round(dz);
            color = -1073741824;
            this.fillEllipse(guiGraphics, x, y, Math.max(3, r), Math.max(3, (int)((float)r * 0.8f)), color);
        }
        int legendX = left + 4;
        int legendY = top + 4;
        this.drawLegendEntry(guiGraphics, legendX, legendY, 0xFFFFFF, "Clouds");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 65280, "Rain");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 25600, "Intense Rain");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 0xFFFF00, "Thunderstorm");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 0xFF0000, "Severe TS");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 0x800080, "Tornado");
        this.drawLegendEntry(guiGraphics, legendX, legendY += 10, 0, "Hurricane");
        ((IScreen)this).sereneseasonsplus$renderNoBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    private static int classifyColor(String cloudId, int severity, boolean thunder) {
        if (thunder) {
            if (WeatherRadarScreen.isSevereThunderId(cloudId)) {
                return 0xFF0000;
            }
            return 0xFFFF00;
        }
        if (severity >= 6) {
            return 25600;
        }
        if (severity >= 5) {
            return 65280;
        }
        return 0xFFFFFF;
    }

    private static boolean isSevereThunderId(String id) {
        return id.equals("severe_cumulonimbus") || id.equals("dense_tsegrus") || id.equals("dark_wall");
    }

    private void drawLegendEntry(GuiGraphics g, int x, int y, int rgb, String label) {
        int color = 0xFF000000 | rgb;
        g.fill(x, y, x + 6, y + 6, color);
        g.drawString(this.font, label, x + 8, y - 1, 0xFFFFFF, false);
    }

    private void fillCircle(GuiGraphics g, int cx, int cy, int r, int argb) {
        if (r <= 0) {
            return;
        }
        int r2 = r * r;
        for (int dy = -r; dy <= r; ++dy) {
            int dx = (int)Math.floor(Math.sqrt(Math.max(0, r2 - dy * dy)));
            g.fill(cx - dx, cy + dy, cx + dx, cy + dy + 1, argb);
        }
    }

    private void fillEllipse(GuiGraphics g, int cx, int cy, int rx, int ry, int argb) {
        rx = Math.max(1, rx);
        ry = Math.max(1, ry);
        int rx2 = rx * rx;
        int ry2 = ry * ry;
        for (int dy = -ry; dy <= ry; ++dy) {
            int y2 = dy * dy;
            double term = 1.0 - (double)y2 / (double)ry2;
            if (term < 0.0) continue;
            int dx = (int)Math.floor(Math.sqrt(term * (double)rx2));
            g.fill(cx - dx, cy + dy, cx + dx, cy + dy + 1, argb);
        }
    }

    private static int jitterColor(Random rand, int rgb, int range) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = WeatherRadarScreen.clamp(0, 255, r + rand.nextInt(range * 2 + 1) - range);
        g = WeatherRadarScreen.clamp(0, 255, g + rand.nextInt(range * 2 + 1) - range);
        b = WeatherRadarScreen.clamp(0, 255, b + rand.nextInt(range * 2 + 1) - range);
        return r << 16 | g << 8 | b;
    }

    private static int clamp(int min, int max, int v) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 334 || keyCode == 81) {
            this.zoom = Math.min(8.0f, this.zoom * 1.25f);
            return true;
        }
        if (keyCode == 333 || keyCode == 82) {
            this.zoom = Math.max(0.25f, this.zoom / 1.25f);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

