/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.humidity;

import java.util.Random;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;

public class HumidityGenerator {
    private static final float CELSIUS_TO_KELVIN = 273.15f;
    public static final float MAX_HUMIDITY = 100.0f;
    public static final float MIN_HUMIDITY_TROPICAL_BIOME = 75.0f;
    public static final float MIN_VANILLA_TEMP_TROPICAL_BIOME = 1.8f;
    public static final float MIN_HUMIDITY_DESERT_BIOME = 5.0f;

    public static float[][] generateWeekForecast(ServerLevel level, BiomeInstanceKey b, Long day) {
        BlockPos pos = b.samplePos();
        ResourceLocation biomeId = b.biomeType();
        BiomeData baseData = AsyncAtmosphereService.callOnMainThread(() -> {
            Biome biome = (Biome)level.getBiome(pos).value();
            float baseRH = biome.getModifiedClimateSettings().downfall() * 100.0f;
            if (!biome.getModifiedClimateSettings().hasPrecipitation()) {
                baseRH = 5.0f;
            } else if (biome.getBaseTemperature() > 1.8f) {
                baseRH = Math.max(baseRH, 75.0f);
            }
            float[][] tempWeek = ForecastGenerator.getClosestValidForecast(b, ForecastType.TEMPERATURE).getTemperature();
            return new BiomeData(baseRH, tempWeek);
        });
        long seed = ProjectAtmosphere.seed ^ pos.asLong() ^ (long)biomeId.hashCode() ^ day;
        Random rand = new Random(seed);
        if (baseData.tempWeek == null) {
            return new float[7][2];
        }
        float[][] humWeek = new float[7][2];
        for (int d = 0; d < 7; ++d) {
            float Tmin = baseData.tempWeek[d][0];
            float Tmax = baseData.tempWeek[d][1];
            float deltaT = Tmax - Tmin;
            float humiditySwing = Math.min(20.0f, deltaT * 2.5f);
            float finalMin = Math.max(5.0f, baseData.baseRH - humiditySwing * 0.5f);
            float finalMax = Math.max(5.0f, baseData.baseRH + humiditySwing * 0.5f);
            float noise = 2.0f * (rand.nextFloat() - 0.5f);
            humWeek[d][0] = Math.max(0.0f, Math.min(finalMin += noise, 100.0f));
            humWeek[d][1] = Math.max(0.0f, Math.min(finalMax += noise, 100.0f));
        }
        return humWeek;
    }

    private record BiomeData(float baseRH, float[][] tempWeek) {
    }
}

