/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.hurricane;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneCategory;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HurricaneInstance {
    public Vec3 position;
    public final long spawnTime;
    public final float radius;
    public final WindVector wind;
    public final HurricaneCategory category;
    private long lastAmbientWindCheck = 0L;
    private final long ambientWindIntervalMs = 2000L;

    public HurricaneInstance(Vec3 position, float radius, WindVector wind, HurricaneCategory category) {
        this.position = position;
        this.radius = radius;
        this.wind = wind;
        this.category = category;
        this.spawnTime = System.currentTimeMillis();
    }

    public float getLifetimeSeconds() {
        return (float)(System.currentTimeMillis() - this.spawnTime) / 1000.0f;
    }

    public void tick(Level level) {
        if (level.isClientSide) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastAmbientWindCheck >= 2000L) {
            this.lastAmbientWindCheck = now;
            this.applyAmbientWind((ServerLevel)level);
        }
    }

    private void applyAmbientWind(ServerLevel level) {
        double influence = this.radius;
        AABB box = new AABB(this.position.x - influence, this.position.y - 5.0, this.position.z - influence, this.position.x + influence, this.position.y + 50.0, this.position.z + influence);
        double windSpeed = this.wind.gustSpeed() * 0.02f;
        double vx = Math.cos(this.wind.angleRadians()) * windSpeed;
        double vz = Math.sin(this.wind.angleRadians()) * windSpeed;
        for (Entity entity : level.getEntities(null, box)) {
            entity.push(vx, 0.0, vz);
        }
    }
}

