/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.pressure;

import java.util.Random;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.util.AtmosphericPhysics;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class PressureGenerator {
    public static final float PRESSION_MOYENNE = 1013.25f;

    public static float[][] generateWeekForecast(BiomeInstanceKey key, Long day) {
        ResourceLocation biome = key.biomeType();
        BlockPos pos = key.samplePos();
        long seed = ProjectAtmosphere.seed ^ pos.asLong() ^ (long)biome.hashCode() ^ day;
        Random rand = new Random(seed);
        double P0 = 1013.25 * Math.pow(1.0 - 0.0065 * (double)pos.getY() / 288.15, 5.255932362359814);
        float base = (float)P0;
        BiomeForecast biomeForecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.TEMPERATURE);
        float[][] tempWeek = biomeForecast.getTemperature();
        float[][] rhWeek = biomeForecast.getHumidity();
        if (tempWeek == null || rhWeek == null) {
            return new float[7][2];
        }
        double[] densities = AtmosphericPhysics.computeAirDensity(tempWeek, rhWeek);
        double referenceDensity = 1.225;
        float[][] week = new float[7][2];
        for (int d = 0; d < 7; ++d) {
            float Tavg = (tempWeek[d][0] + tempWeek[d][1]) * 0.5f;
            float deltaT = -0.5f * (Tavg - 15.0f);
            float densityModifier = (float)(densities[d] / referenceDensity);
            float deltaDensity = (densityModifier - 1.0f) * 30.0f;
            float center = base + deltaT + deltaDensity;
            float volatility = 0.3f;
            float variation = 2.0f * volatility;
            float offset = (rand.nextFloat() - 0.5f) * variation;
            float min = center - variation + offset;
            float max = center + offset;
            week[d][0] = Math.max(870.0f, Math.min(min, 1080.0f));
            week[d][1] = Math.max(870.0f, Math.min(max, 1080.0f));
        }
        return week;
    }
}

