/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.storm;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class GlobalStormHistoryData
extends SavedData {
    private static final String STORAGE_ID = "project_atmosphere_storm_history";
    private int lastSevereDay = Integer.MIN_VALUE;

    public static GlobalStormHistoryData get(ServerLevel level) {
        return (GlobalStormHistoryData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(GlobalStormHistoryData::new, GlobalStormHistoryData::load), STORAGE_ID);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("lastSevereDay", this.lastSevereDay);
        return tag;
    }

    public static GlobalStormHistoryData load(CompoundTag tag, HolderLookup.Provider provider) {
        GlobalStormHistoryData data = new GlobalStormHistoryData();
        data.lastSevereDay = tag.getInt("lastSevereDay");
        return data;
    }

    public int getLastSevereDay() {
        return this.lastSevereDay;
    }

    public void recordSevere(int dayIndex) {
        this.lastSevereDay = dayIndex;
        this.setDirty();
    }
}

