/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.config;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.minecraft.resources.ResourceLocation;

public class BiomeTempConfig {
    public static final Map<Season, Map<ResourceLocation, Range>> SEASON_RANGES = new EnumMap<Season, Map<ResourceLocation, Range>>(Season.class);
    public static final Map<Season, Map<ResourceLocation, DailyRange>> SEASON_CLAMPS = new EnumMap<Season, Map<ResourceLocation, DailyRange>>(Season.class);

    private static void putAllSeasons(String biomeKey, Range[] ranges) {
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)biomeKey);
        Season[] seasons = Season.values();
        for (int i = 0; i < seasons.length; ++i) {
            Season season = seasons[i];
            Range r = ranges[i];
            SEASON_RANGES.get((Object)season).put(id, r);
            SEASON_CLAMPS.get((Object)season).put(id, BiomeTempConfig.deriveDaily(r));
        }
    }

    private static void mirrorBiome(String dstKey, String srcKey) {
        ResourceLocation src = ResourceLocation.withDefaultNamespace((String)srcKey);
        ResourceLocation dst = ResourceLocation.withDefaultNamespace((String)dstKey);
        for (Season s : Season.values()) {
            SEASON_RANGES.get((Object)s).put(dst, SEASON_RANGES.get((Object)s).get(src));
            SEASON_CLAMPS.get((Object)s).put(dst, SEASON_CLAMPS.get((Object)s).get(src));
        }
    }

    private static void putConstSeasons(String biomeKey, Range r, DailyRange d) {
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)biomeKey);
        for (Season s : Season.values()) {
            SEASON_RANGES.get((Object)s).put(id, r);
            SEASON_CLAMPS.get((Object)s).put(id, d);
        }
    }

    public static DailyRange deriveDaily(Range r) {
        float span = r.maxC - r.minC;
        float minMin = r.minC - 0.1f * span;
        float avgNight = r.minC + 0.25f * span;
        float avgDay = r.minC + 0.75f * span;
        float maxMax = r.maxC + 0.1f * span;
        return new DailyRange(minMin, avgNight, avgDay, maxMax);
    }

    public static Range getRange(ResourceLocation biome, Season season) {
        if (!SEASON_RANGES.getOrDefault((Object)season, Map.of()).containsKey(biome)) {
            ProjectAtmosphere.LOGGER.warn("\u274c No temperature range defined for biome {}", (Object)biome);
        }
        return SEASON_RANGES.getOrDefault((Object)season, Map.of()).getOrDefault(biome, new Range(0.0f, 0.0f));
    }

    public static DailyRange getClamp(ResourceLocation biome, Season season) {
        return SEASON_CLAMPS.getOrDefault((Object)season, Map.of()).getOrDefault(biome, new DailyRange(0.0f, 0.0f, 0.0f, 0.0f));
    }

    static {
        for (Season s : Season.values()) {
            SEASON_RANGES.put(s, new HashMap());
            SEASON_CLAMPS.put(s, new HashMap());
        }
        BiomeTempConfig.putAllSeasons("plains", new Range[]{new Range(-20.0f, 5.0f), new Range(-10.0f, 18.0f), new Range(15.0f, 36.0f), new Range(-6.0f, 18.0f)});
        BiomeTempConfig.mirrorBiome("sunflower_plains", "plains");
        BiomeTempConfig.putAllSeasons("forest", new Range[]{new Range(-18.0f, 5.0f), new Range(-7.0f, 13.0f), new Range(7.0f, 28.0f), new Range(-2.0f, 19.0f)});
        BiomeTempConfig.mirrorBiome("flower_forest", "forest");
        BiomeTempConfig.mirrorBiome("birch_forest", "forest");
        BiomeTempConfig.mirrorBiome("old_growth_birch_forest", "forest");
        BiomeTempConfig.putAllSeasons("dark_forest", new Range[]{new Range(-22.0f, 3.0f), new Range(-12.0f, 11.0f), new Range(8.0f, 24.0f), new Range(-9.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("beach", new Range[]{new Range(-2.0f, 8.0f), new Range(2.0f, 14.0f), new Range(15.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("cherry_grove", new Range[]{new Range(-12.0f, 2.0f), new Range(-1.0f, 14.0f), new Range(8.0f, 28.0f), new Range(4.0f, 21.0f)});
        BiomeTempConfig.putAllSeasons("swamp", new Range[]{new Range(-5.0f, 10.0f), new Range(10.0f, 22.0f), new Range(20.0f, 35.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("meadow", new Range[]{new Range(-12.0f, 3.0f), new Range(2.0f, 14.0f), new Range(15.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("taiga", new Range[]{new Range(-25.0f, -5.0f), new Range(-5.0f, 10.0f), new Range(10.0f, 22.0f), new Range(-5.0f, 10.0f)});
        BiomeTempConfig.mirrorBiome("old_growth_spruce_taiga", "taiga");
        BiomeTempConfig.mirrorBiome("old_growth_pine_taiga", "taiga");
        BiomeTempConfig.mirrorBiome("snowy_taiga", "taiga");
        BiomeTempConfig.putAllSeasons("snowy_plains", new Range[]{new Range(-35.0f, -10.0f), new Range(-15.0f, 5.0f), new Range(5.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("ice_spikes", new Range[]{new Range(-50.0f, -30.0f), new Range(-30.0f, -5.0f), new Range(-5.0f, 5.0f), new Range(-30.0f, 0.0f)});
        BiomeTempConfig.mirrorBiome("snowy_slopes", "snowy_plains");
        BiomeTempConfig.putAllSeasons("frozen_peaks", new Range[]{new Range(-45.0f, -25.0f), new Range(-25.0f, -10.0f), new Range(-10.0f, 0.0f), new Range(-25.0f, -5.0f)});
        BiomeTempConfig.putAllSeasons("jungle", new Range[]{new Range(20.0f, 25.0f), new Range(22.0f, 30.0f), new Range(25.0f, 35.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("sparse_jungle", "jungle");
        BiomeTempConfig.mirrorBiome("bamboo_jungle", "jungle");
        BiomeTempConfig.putAllSeasons("desert", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 35.0f), new Range(30.0f, 45.0f), new Range(15.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("badlands", new Range[]{new Range(0.0f, 20.0f), new Range(10.0f, 30.0f), new Range(25.0f, 40.0f), new Range(10.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("wooded_badlands", "badlands");
        BiomeTempConfig.mirrorBiome("eroded_badlands", "badlands");
        BiomeTempConfig.putAllSeasons("savanna", new Range[]{new Range(10.0f, 25.0f), new Range(15.0f, 30.0f), new Range(20.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.mirrorBiome("windswept_savanna", "savanna");
        BiomeTempConfig.mirrorBiome("mangrove_swamp", "swamp");
        BiomeTempConfig.putAllSeasons("ocean", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 15.0f), new Range(10.0f, 20.0f), new Range(5.0f, 15.0f)});
        BiomeTempConfig.mirrorBiome("lukewarm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("warm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("cold_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("frozen_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_lukewarm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_warm_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_cold_ocean", "ocean");
        BiomeTempConfig.mirrorBiome("deep_frozen_ocean", "ocean");
        BiomeTempConfig.putAllSeasons("river", new Range[]{new Range(-5.0f, 5.0f), new Range(5.0f, 18.0f), new Range(18.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.mirrorBiome("frozen_river", "river");
        BiomeTempConfig.putAllSeasons("mushroom_fields", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 20.0f), new Range(15.0f, 25.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.mirrorBiome("mushroom_field_shore", "mushroom_fields");
        BiomeTempConfig.putAllSeasons("lush_caves", new Range[]{new Range(12.0f, 15.0f), new Range(14.0f, 18.0f), new Range(15.0f, 20.0f), new Range(14.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("dripstone_caves", new Range[]{new Range(8.0f, 12.0f), new Range(10.0f, 15.0f), new Range(10.0f, 15.0f), new Range(10.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("deep_dark", new Range[]{new Range(5.0f, 10.0f), new Range(7.0f, 10.0f), new Range(8.0f, 12.0f), new Range(7.0f, 10.0f)});
        BiomeTempConfig.mirrorBiome("savanna_plateau", "savanna");
        BiomeTempConfig.mirrorBiome("stony_shore", "beach");
        BiomeTempConfig.mirrorBiome("snowy_beach", "beach");
        BiomeTempConfig.mirrorBiome("windswept_gravelly_hills", "taiga");
        BiomeTempConfig.mirrorBiome("windswept_forest", "taiga");
        BiomeTempConfig.mirrorBiome("windswept_hills", "taiga");
        BiomeTempConfig.mirrorBiome("jagged_peaks", "frozen_peaks");
        BiomeTempConfig.mirrorBiome("stony_peaks", "frozen_peaks");
        BiomeTempConfig.mirrorBiome("grove", "snowy_slopes");
        BiomeTempConfig.putConstSeasons("nether_wastes", new Range(45.0f, 50.0f), new DailyRange(40.0f, 45.0f, 47.0f, 52.0f));
        BiomeTempConfig.putConstSeasons("basalt_deltas", new Range(50.0f, 55.0f), new DailyRange(45.0f, 50.0f, 53.0f, 60.0f));
        BiomeTempConfig.putConstSeasons("crimson_forest", new Range(40.0f, 45.0f), new DailyRange(35.0f, 40.0f, 43.0f, 48.0f));
        BiomeTempConfig.putConstSeasons("warped_forest", new Range(30.0f, 40.0f), new DailyRange(25.0f, 32.0f, 35.0f, 45.0f));
        BiomeTempConfig.putConstSeasons("soul_sand_valley", new Range(35.0f, 45.0f), new DailyRange(30.0f, 38.0f, 42.0f, 50.0f));
        BiomeTempConfig.putConstSeasons("the_end", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("end_highlands", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("end_midlands", new Range(5.0f, 10.0f), new DailyRange(0.0f, 7.0f, 8.0f, 12.0f));
        BiomeTempConfig.putConstSeasons("small_end_islands", new Range(0.0f, 5.0f), new DailyRange(-5.0f, 2.0f, 4.0f, 8.0f));
        BiomeTempConfig.putConstSeasons("end_barrens", new Range(0.0f, 5.0f), new DailyRange(-5.0f, 2.0f, 4.0f, 8.0f));
        BiomeTempConfig.putConstSeasons("the_void", new Range(-273.0f, -273.0f), new DailyRange(-273.0f, -273.0f, -273.0f, -273.0f));
        BiomeTempConfig.putAllSeasons("auroral_garden", new Range[]{new Range(-30.0f, 0.0f), new Range(-10.0f, 10.0f), new Range(5.0f, 20.0f), new Range(-5.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("bamboo_grove", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("bayou", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("bog", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("cold_desert", new Range[]{new Range(-20.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("coniferous_forest", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("crag", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("dead_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("dryland", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("dune_beach", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("field", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("fir_clearing", new Range[]{new Range(-5.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("floodplain", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("forested_field", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("fungal_jungle", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("grassland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("highland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("highland_moor", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("hot_springs", new Range[]{new Range(0.0f, 10.0f), new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(5.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("jacaranda_glade", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("jade_cliffs", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("lavender_field", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("lush_desert", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("lush_savanna", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("maple_woods", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("marsh", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_forest", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("muskeg", new Range[]{new Range(-20.0f, 5.0f), new Range(-5.0f, 15.0f), new Range(5.0f, 20.0f), new Range(-5.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("mystic_grove", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_dead_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_woodland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("ominous_woods", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("orchard", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("origin_valley", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("pasture", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("prairie", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("pumpkin_patch", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("rainforest", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("redwood_forest", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("rocky_rainforest", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("rocky_shrubland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("scrubland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("seasonal_forest", new Range[]{new Range(-10.0f, 5.0f), new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.mirrorBiome("shrubland", "scrubland");
        BiomeTempConfig.putAllSeasons("snowblossom_grove", new Range[]{new Range(-30.0f, 0.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_coniferous_forest", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_fir_clearing", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("snowy_maple_woods", new Range[]{new Range(-30.0f, -5.0f), new Range(-15.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-15.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("tropics", new Range[]{new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(35.0f, 50.0f), new Range(30.0f, 45.0f)});
        BiomeTempConfig.putAllSeasons("tundra", new Range[]{new Range(-35.0f, -5.0f), new Range(-20.0f, 5.0f), new Range(0.0f, 15.0f), new Range(-20.0f, 5.0f)});
        BiomeTempConfig.putAllSeasons("volcanic_plains", new Range[]{new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(30.0f, 45.0f), new Range(25.0f, 40.0f)});
        BiomeTempConfig.putAllSeasons("volcano", new Range[]{new Range(25.0f, 40.0f), new Range(35.0f, 50.0f), new Range(40.0f, 60.0f), new Range(35.0f, 50.0f)});
        BiomeTempConfig.putAllSeasons("wasteland", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(25.0f, 40.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("wetland", new Range[]{new Range(5.0f, 20.0f), new Range(15.0f, 30.0f), new Range(25.0f, 40.0f), new Range(15.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("woodland", new Range[]{new Range(0.0f, 15.0f), new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(10.0f, 25.0f)});
        BiomeTempConfig.putAllSeasons("aspen_parkland", new Range[]{new Range(-15.0f, 5.0f), new Range(0.0f, 18.0f), new Range(15.0f, 30.0f), new Range(0.0f, 15.0f)});
        BiomeTempConfig.putAllSeasons("dunes", new Range[]{new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("flourishing_dunes", new Range[]{new Range(12.0f, 25.0f), new Range(20.0f, 35.0f), new Range(28.0f, 42.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("kousa_jungle", new Range[]{new Range(-10.0f, 2.0f), new Range(0.0f, 15.0f), new Range(15.0f, 25.0f), new Range(0.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("laurel_forest", new Range[]{new Range(-2.0f, 8.0f), new Range(5.0f, 18.0f), new Range(15.0f, 30.0f), new Range(5.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("petrified_dunes", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("rainforest", new Range[]{new Range(20.0f, 28.0f), new Range(22.0f, 32.0f), new Range(25.0f, 36.0f), new Range(22.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("rainforest_basin", new Range[]{new Range(21.0f, 29.0f), new Range(23.0f, 33.0f), new Range(26.0f, 36.0f), new Range(23.0f, 33.0f)});
        BiomeTempConfig.putAllSeasons("rocky_dunes", new Range[]{new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(28.0f, 43.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("scrubland", new Range[]{new Range(5.0f, 18.0f), new Range(15.0f, 28.0f), new Range(25.0f, 38.0f), new Range(15.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("snowy_scrubland", new Range[]{new Range(-25.0f, -5.0f), new Range(-10.0f, 8.0f), new Range(5.0f, 18.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("sparse_rainforest", new Range[]{new Range(18.0f, 25.0f), new Range(20.0f, 30.0f), new Range(24.0f, 35.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("sparse_rainforest_basin", new Range[]{new Range(18.0f, 26.0f), new Range(21.0f, 31.0f), new Range(25.0f, 36.0f), new Range(21.0f, 31.0f)});
        BiomeTempConfig.putAllSeasons("spiny_thicket", new Range[]{new Range(10.0f, 25.0f), new Range(20.0f, 35.0f), new Range(30.0f, 45.0f), new Range(20.0f, 35.0f)});
        BiomeTempConfig.putAllSeasons("alpine_heathlands", new Range[]{new Range(-12.0f, 2.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("alpine_plains", new Range[]{new Range(-12.0f, 2.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("alpine_tundra", new Range[]{new Range(-18.0f, -5.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_beach", new Range[]{new Range(-18.0f, -2.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 12.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("arctic_deep_ocean", new Range[]{new Range(-4.0f, 2.0f), new Range(0.0f, 6.0f), new Range(4.0f, 10.0f), new Range(0.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("arctic_desert", new Range[]{new Range(-35.0f, -10.0f), new Range(-20.0f, 0.0f), new Range(-5.0f, 10.0f), new Range(-20.0f, -2.0f)});
        BiomeTempConfig.putAllSeasons("arctic_desert_basin", new Range[]{new Range(-20.0f, -5.0f), new Range(-10.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_glacier", new Range[]{new Range(-45.0f, -25.0f), new Range(-30.0f, -10.0f), new Range(-12.0f, 2.0f), new Range(-28.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("arctic_shallow_ocean", new Range[]{new Range(-3.0f, 2.0f), new Range(0.0f, 7.0f), new Range(5.0f, 12.0f), new Range(0.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("arctic_wetlands", new Range[]{new Range(-15.0f, -2.0f), new Range(-5.0f, 10.0f), new Range(8.0f, 18.0f), new Range(-2.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("arid_beach", new Range[]{new Range(12.0f, 22.0f), new Range(18.0f, 30.0f), new Range(24.0f, 38.0f), new Range(18.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("arid_desert", new Range[]{new Range(10.0f, 22.0f), new Range(20.0f, 34.0f), new Range(28.0f, 45.0f), new Range(18.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("arid_highlands", new Range[]{new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(24.0f, 40.0f), new Range(14.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("barren_arctic_desert", new Range[]{new Range(-40.0f, -20.0f), new Range(-28.0f, -8.0f), new Range(-12.0f, 2.0f), new Range(-28.0f, -8.0f)});
        BiomeTempConfig.putAllSeasons("barren_caves", new Range[]{new Range(6.0f, 10.0f), new Range(8.0f, 12.0f), new Range(10.0f, 14.0f), new Range(8.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("barren_mediterranean_highlands", new Range[]{new Range(5.0f, 15.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("barren_peaks", new Range[]{new Range(-8.0f, 2.0f), new Range(0.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("birch_forest", new Range[]{new Range(-6.0f, 8.0f), new Range(4.0f, 18.0f), new Range(14.0f, 28.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("bog", new Range[]{new Range(-4.0f, 6.0f), new Range(4.0f, 16.0f), new Range(12.0f, 24.0f), new Range(4.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("boreal_alpine_tundra", new Range[]{new Range(-20.0f, -6.0f), new Range(-8.0f, 6.0f), new Range(4.0f, 16.0f), new Range(-6.0f, 6.0f)});
        BiomeTempConfig.putAllSeasons("boreal_river", new Range[]{new Range(-8.0f, 2.0f), new Range(2.0f, 12.0f), new Range(10.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_barren_highlands", new Range[]{new Range(-10.0f, 0.0f), new Range(-2.0f, 12.0f), new Range(6.0f, 20.0f), new Range(-2.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_deep_ocean", new Range[]{new Range(0.0f, 6.0f), new Range(4.0f, 10.0f), new Range(8.0f, 14.0f), new Range(4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_desert", new Range[]{new Range(-6.0f, 10.0f), new Range(6.0f, 20.0f), new Range(16.0f, 30.0f), new Range(6.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("cold_semi_desert", new Range[]{new Range(-4.0f, 12.0f), new Range(6.0f, 22.0f), new Range(16.0f, 32.0f), new Range(6.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("cold_shallow_ocean", new Range[]{new Range(1.0f, 7.0f), new Range(5.0f, 12.0f), new Range(9.0f, 15.0f), new Range(5.0f, 11.0f)});
        BiomeTempConfig.putAllSeasons("cold_steppe", new Range[]{new Range(-10.0f, 2.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(0.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("cold_taiga", new Range[]{new Range(-25.0f, -5.0f), new Range(-5.0f, 10.0f), new Range(10.0f, 20.0f), new Range(-5.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("cold_taiga_clearings", new Range[]{new Range(-24.0f, -4.0f), new Range(-4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(-4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("cold_tundra_beach", new Range[]{new Range(-14.0f, -2.0f), new Range(-4.0f, 8.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("desert_river", new Range[]{new Range(12.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("desert_wetlands", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 34.0f), new Range(26.0f, 40.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("dry_cold_steppe", new Range[]{new Range(-12.0f, 0.0f), new Range(0.0f, 14.0f), new Range(10.0f, 24.0f), new Range(-2.0f, 12.0f)});
        BiomeTempConfig.putAllSeasons("dry_tropical_highlands", new Range[]{new Range(10.0f, 20.0f), new Range(16.0f, 28.0f), new Range(20.0f, 34.0f), new Range(14.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("evergreen_taiga", new Range[]{new Range(-22.0f, -4.0f), new Range(-4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(-4.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("fen", new Range[]{new Range(0.0f, 10.0f), new Range(6.0f, 20.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("flooded_grasslands", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 24.0f), new Range(18.0f, 30.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("flooded_savanna", new Range[]{new Range(16.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("frozen_caves", new Range[]{new Range(-2.0f, 2.0f), new Range(0.0f, 4.0f), new Range(2.0f, 6.0f), new Range(0.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("glacial_basin", new Range[]{new Range(-42.0f, -22.0f), new Range(-28.0f, -8.0f), new Range(-10.0f, 4.0f), new Range(-26.0f, -6.0f)});
        BiomeTempConfig.putAllSeasons("glowing_caves", new Range[]{new Range(8.0f, 12.0f), new Range(10.0f, 14.0f), new Range(12.0f, 16.0f), new Range(10.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("grassland_savanna", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(26.0f, 38.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("haunted_depths", new Range[]{new Range(7.0f, 11.0f), new Range(9.0f, 13.0f), new Range(11.0f, 15.0f), new Range(9.0f, 13.0f)});
        BiomeTempConfig.putAllSeasons("humid_savanna", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(22.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("infested_tunnels", new Range[]{new Range(7.0f, 11.0f), new Range(9.0f, 13.0f), new Range(11.0f, 15.0f), new Range(9.0f, 13.0f)});
        BiomeTempConfig.putAllSeasons("larch_woodlands", new Range[]{new Range(-8.0f, 6.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("mangrove_marsh", new Range[]{new Range(16.0f, 24.0f), new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_beach", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 24.0f), new Range(20.0f, 30.0f), new Range(14.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_forest", new Range[]{new Range(4.0f, 14.0f), new Range(10.0f, 22.0f), new Range(20.0f, 34.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_highlands", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_marsh", new Range[]{new Range(8.0f, 18.0f), new Range(14.0f, 26.0f), new Range(20.0f, 32.0f), new Range(12.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_river", new Range[]{new Range(8.0f, 16.0f), new Range(14.0f, 24.0f), new Range(20.0f, 30.0f), new Range(14.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_shrubland", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 24.0f), new Range(20.0f, 34.0f), new Range(10.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_steppe", new Range[]{new Range(4.0f, 16.0f), new Range(12.0f, 26.0f), new Range(20.0f, 36.0f), new Range(10.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_swamp", new Range[]{new Range(8.0f, 18.0f), new Range(14.0f, 26.0f), new Range(20.0f, 32.0f), new Range(12.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("mediterranean_wooded_highlands", new Range[]{new Range(2.0f, 12.0f), new Range(8.0f, 20.0f), new Range(16.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("mire", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("mixed_forest_steppe", new Range[]{new Range(-6.0f, 6.0f), new Range(4.0f, 18.0f), new Range(14.0f, 28.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("monsoon_forest", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(24.0f, 36.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("mushroom_caves", new Range[]{new Range(10.0f, 12.0f), new Range(12.0f, 14.0f), new Range(14.0f, 16.0f), new Range(12.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_temperate_forest", new Range[]{new Range(-4.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("old_growth_tropical_rainforest", new Range[]{new Range(20.0f, 26.0f), new Range(22.0f, 32.0f), new Range(24.0f, 34.0f), new Range(22.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("pine_woods", new Range[]{new Range(-10.0f, 4.0f), new Range(2.0f, 16.0f), new Range(12.0f, 26.0f), new Range(2.0f, 14.0f)});
        BiomeTempConfig.putAllSeasons("savanna_beach", new Range[]{new Range(16.0f, 24.0f), new Range(20.0f, 30.0f), new Range(24.0f, 34.0f), new Range(20.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("savanna_highlands", new Range[]{new Range(14.0f, 24.0f), new Range(20.0f, 32.0f), new Range(26.0f, 38.0f), new Range(18.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("savanna_river", new Range[]{new Range(16.0f, 24.0f), new Range(22.0f, 32.0f), new Range(26.0f, 36.0f), new Range(20.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("scorched_caves", new Range[]{new Range(18.0f, 22.0f), new Range(20.0f, 24.0f), new Range(22.0f, 28.0f), new Range(20.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("semiarid_desert", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("shrub_steppe", new Range[]{new Range(2.0f, 14.0f), new Range(10.0f, 24.0f), new Range(18.0f, 32.0f), new Range(8.0f, 22.0f)});
        BiomeTempConfig.putAllSeasons("snowy_barren_peaks", new Range[]{new Range(-22.0f, -6.0f), new Range(-10.0f, 4.0f), new Range(0.0f, 12.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("snowy_peaks", new Range[]{new Range(-20.0f, -5.0f), new Range(-8.0f, 6.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("snowy_tundra", new Range[]{new Range(-28.0f, -8.0f), new Range(-12.0f, 4.0f), new Range(2.0f, 14.0f), new Range(-12.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("steppe_river", new Range[]{new Range(0.0f, 10.0f), new Range(10.0f, 22.0f), new Range(18.0f, 30.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("subtropical_deep_ocean", new Range[]{new Range(16.0f, 22.0f), new Range(20.0f, 26.0f), new Range(24.0f, 30.0f), new Range(20.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("subtropical_shallow_ocean", new Range[]{new Range(18.0f, 24.0f), new Range(22.0f, 28.0f), new Range(26.0f, 32.0f), new Range(22.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("taiga_beach", new Range[]{new Range(-10.0f, 2.0f), new Range(0.0f, 12.0f), new Range(8.0f, 20.0f), new Range(0.0f, 10.0f)});
        BiomeTempConfig.putAllSeasons("taiga_highlands", new Range[]{new Range(-16.0f, -2.0f), new Range(-4.0f, 10.0f), new Range(8.0f, 20.0f), new Range(-4.0f, 8.0f)});
        BiomeTempConfig.putAllSeasons("temperate_beach", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 20.0f), new Range(16.0f, 26.0f), new Range(10.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_deep_ocean", new Range[]{new Range(10.0f, 14.0f), new Range(12.0f, 16.0f), new Range(14.0f, 18.0f), new Range(12.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("temperate_forest", new Range[]{new Range(-4.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_marsh", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_mixed_forest", new Range[]{new Range(-6.0f, 8.0f), new Range(6.0f, 18.0f), new Range(14.0f, 28.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_river", new Range[]{new Range(0.0f, 10.0f), new Range(8.0f, 20.0f), new Range(14.0f, 26.0f), new Range(6.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_shallow_ocean", new Range[]{new Range(12.0f, 16.0f), new Range(14.0f, 18.0f), new Range(16.0f, 20.0f), new Range(14.0f, 18.0f)});
        BiomeTempConfig.putAllSeasons("temperate_swamp", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(16.0f, 28.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("tropical_beach", new Range[]{new Range(20.0f, 26.0f), new Range(24.0f, 30.0f), new Range(26.0f, 32.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_deep_ocean", new Range[]{new Range(18.0f, 24.0f), new Range(22.0f, 28.0f), new Range(26.0f, 30.0f), new Range(22.0f, 28.0f)});
        BiomeTempConfig.putAllSeasons("tropical_dry_forest", new Range[]{new Range(18.0f, 26.0f), new Range(22.0f, 34.0f), new Range(24.0f, 36.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("tropical_highlands", new Range[]{new Range(14.0f, 22.0f), new Range(18.0f, 28.0f), new Range(20.0f, 30.0f), new Range(16.0f, 26.0f)});
        BiomeTempConfig.putAllSeasons("tropical_rainforest", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_rainforest_river", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_shallow_ocean", new Range[]{new Range(22.0f, 26.0f), new Range(24.0f, 30.0f), new Range(26.0f, 32.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tropical_wetlands", new Range[]{new Range(22.0f, 28.0f), new Range(24.0f, 32.0f), new Range(24.0f, 34.0f), new Range(24.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("tundra_beach", new Range[]{new Range(-10.0f, -2.0f), new Range(-4.0f, 8.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_clearings", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_river", new Range[]{new Range(4.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 30.0f), new Range(10.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("warm_temperate_woodlands", new Range[]{new Range(2.0f, 12.0f), new Range(10.0f, 22.0f), new Range(18.0f, 32.0f), new Range(8.0f, 20.0f)});
        BiomeTempConfig.putAllSeasons("wooded_highlands", new Range[]{new Range(-6.0f, 6.0f), new Range(4.0f, 18.0f), new Range(12.0f, 26.0f), new Range(4.0f, 16.0f)});
        BiomeTempConfig.putAllSeasons("wooded_mediterranean_steppe", new Range[]{new Range(6.0f, 16.0f), new Range(12.0f, 26.0f), new Range(20.0f, 36.0f), new Range(10.0f, 24.0f)});
        BiomeTempConfig.putAllSeasons("wooded_savanna", new Range[]{new Range(16.0f, 26.0f), new Range(22.0f, 34.0f), new Range(26.0f, 38.0f), new Range(20.0f, 32.0f)});
        BiomeTempConfig.putAllSeasons("wooded_semiarid_desert", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("xeric_shrubland", new Range[]{new Range(8.0f, 22.0f), new Range(18.0f, 32.0f), new Range(26.0f, 42.0f), new Range(16.0f, 30.0f)});
        BiomeTempConfig.putAllSeasons("arctic_river", new Range[]{new Range(-18.0f, -2.0f), new Range(-8.0f, 6.0f), new Range(4.0f, 14.0f), new Range(-6.0f, 4.0f)});
        BiomeTempConfig.putAllSeasons("arctic_tundra", new Range[]{new Range(-40.0f, -20.0f), new Range(-25.0f, -5.0f), new Range(-5.0f, 12.0f), new Range(-20.0f, -4.0f)});
        BiomeTempConfig.putAllSeasons("barren_tundra", new Range[]{new Range(-35.0f, -15.0f), new Range(-22.0f, -2.0f), new Range(-2.0f, 10.0f), new Range(-18.0f, -4.0f)});
        BiomeTempConfig.putAllSeasons("lush_tundra", new Range[]{new Range(-28.0f, -10.0f), new Range(-10.0f, 4.0f), new Range(2.0f, 14.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("snowy_boreal_alpine_tundra", new Range[]{new Range(-30.0f, -12.0f), new Range(-14.0f, 2.0f), new Range(4.0f, 16.0f), new Range(-10.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("tundra_river", new Range[]{new Range(-20.0f, -5.0f), new Range(-10.0f, 4.0f), new Range(4.0f, 14.0f), new Range(-8.0f, 2.0f)});
        BiomeTempConfig.putAllSeasons("wooded_tundra", new Range[]{new Range(-26.0f, -8.0f), new Range(-10.0f, 6.0f), new Range(6.0f, 18.0f), new Range(-6.0f, 4.0f)});
    }

    public static enum Season {
        WINTER,
        SPRING,
        SUMMER,
        AUTUMN;

    }

    public record Range(float minC, float maxC) {
    }

    public record DailyRange(float minMin, float avgNight, float avgDay, float maxMax) {
    }
}

