/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.registry.ModTags;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public class GlassDamageManager {
    private static final long REPAIR_DELAY_MS = 300000L;
    private static final Map<BlockPos, GlassState> GLASS_STATE = new HashMap<BlockPos, GlassState>();
    private static final int MAX_DAMAGE = 8;
    public static boolean DEBUG_GLASS_DAMAGE = false;
    public static boolean DEBUG_GLASS_REPAIR = false;
    public static boolean DEBUG_GLASS_DESTROY = false;
    public static boolean doDamageGlass = (Boolean)AtmoCommonConfig.DAMAGE_GLASS_ON_TORNADO.get();
    public static boolean doAutoRepairGlass = (Boolean)AtmoCommonConfig.AUTO_REPAIR_GLASS.get();
    private static LongArrayList toDestroy = new LongArrayList(2048);
    private static int _destroyCursor = 0;

    public static void damageGlass(ServerLevel level, LongArrayList toProcess) {
        if (toProcess.isEmpty()) {
            return;
        }
        for (int i = 0; i < toProcess.size(); ++i) {
            BlockState state;
            BlockPos pos = BlockPos.of((long)toProcess.getLong(i));
            if (!level.isLoaded(pos) || !GlassDamageManager.isGlass(state = level.getBlockState(pos))) continue;
            GlassState glass = GLASS_STATE.computeIfAbsent(pos.immutable(), p -> new GlassState(state));
            glass.damage = Math.min(8, glass.damage + 1);
            glass.lastDamageTime = System.currentTimeMillis();
            if (glass.damage < 8 || glass.broken || !doDamageGlass) continue;
            toDestroy.add(pos.asLong());
            glass.broken = true;
        }
        if (toDestroy.isEmpty()) {
            return;
        }
        int perTick = 256;
        _destroyCursor = 0;
        AsyncAtmosphereService.runOnMainThread(() -> GlassDamageManager.processGlassDestruction(level, toDestroy, 256));
    }

    private static void processGlassDestruction(ServerLevel level, LongArrayList list, int perTick) {
        if (_destroyCursor >= list.size()) {
            _destroyCursor = 0;
            return;
        }
        int end = Math.min(_destroyCursor + perTick, list.size());
        for (int i = _destroyCursor; i < end; ++i) {
            BlockState state;
            BlockPos pos = BlockPos.of((long)list.getLong(i));
            if (!level.isLoaded(pos) || !GlassDamageManager.isGlass(state = level.getBlockState(pos))) continue;
            level.destroyBlock(pos, false);
        }
        _destroyCursor = end;
        if (_destroyCursor < list.size()) {
            level.getServer().execute(() -> GlassDamageManager.processGlassDestruction(level, list, perTick));
        } else {
            _destroyCursor = 0;
        }
    }

    public static void tick(ServerLevel level) {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<BlockPos, GlassState>> iterator = GLASS_STATE.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, GlassState> entry = iterator.next();
            GlassState state = entry.getValue();
            if (now - state.lastDamageTime < 300000L) continue;
            if (state.broken && doAutoRepairGlass) {
                level.setBlock(entry.getKey(), state.originalState, 3);
            }
            iterator.remove();
        }
    }

    private static boolean isGlass(BlockState state) {
        return state.is(ModTags.GLASS_LIKE);
    }

    private static class GlassState {
        final BlockState originalState;
        int damage = 0;
        boolean broken = false;
        long lastDamageTime = System.currentTimeMillis();

        GlassState(BlockState originalState) {
            this.originalState = originalState;
        }
    }
}

