/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

public enum TornadoLevel {
    F1(73.0f, 112.0f, 5.0),
    F2(113.0f, 157.0f, 10.0),
    F3(158.0f, 206.0f, 20.0),
    F4(207.0f, 260.0f, 40.0),
    F5(261.0f, 318.0f, 80.0);

    private final float minWindSpeed;
    private final float maxWindSpeed;
    private final double baseDamage;

    private TornadoLevel(float minWindSpeed, float maxWindSpeed, double baseDamage) {
        this.minWindSpeed = minWindSpeed;
        this.maxWindSpeed = maxWindSpeed;
        this.baseDamage = baseDamage;
    }

    public float getMinWindSpeed() {
        return this.minWindSpeed;
    }

    public float getMaxWindSpeed() {
        return this.maxWindSpeed;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public static TornadoLevel fromWindSpeed(float windSpeed) {
        for (TornadoLevel level : TornadoLevel.values()) {
            if (!(windSpeed >= level.minWindSpeed) || !(windSpeed <= level.maxWindSpeed)) continue;
            return level;
        }
        return F1;
    }
}

