/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import net.Gabou.projectatmosphere.render.HurricaneStateProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public final class HurricaneMeshRenderer {
    private HurricaneMeshRenderer() {
    }

    public static void renderCloudSpace(SimpleCloudsRenderer sc, PoseStack pose, Matrix4f proj, float partialTick, double camX, double camZ) {
        BufferBuilder bufferbuilder;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        HurricaneStateProvider.HurricaneStateCloudSpace state = HurricaneStateProvider.getActive(camX, camZ);
        if (state == null) {
            return;
        }
        float cx = (float)state.centerXCloudSpace();
        float cz = (float)state.centerZCloudSpace();
        float inner = (float)state.eyeRadiusCloudSpace();
        float outer = inner + (float)state.eyewallFadeCloudSpace();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        ShaderInstance shader = RenderSystem.getShader();
        SimpleCloudsRenderer.prepareShader((ShaderInstance)shader, (Matrix4f)pose.last().pose(), (Matrix4f)proj, (float)sc.getFogStart(), (float)sc.getFogEnd());
        shader.apply();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder consumer = bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        int segs = 160;
        float y = 0.02f;
        float twoPi = (float)Math.PI * 2;
        Matrix4f mv = pose.last().pose();
        for (int i = 0; i <= 160; ++i) {
            float a = (float)Math.PI * 2 * (float)i / 160.0f;
            float cs = (float)Math.cos(a);
            float sn = (float)Math.sin(a);
            consumer.addVertex(mv, cx + cs * inner, 0.02f, cz + sn * inner);
            consumer.addVertex(mv, cx + cs * outer, 0.02f, cz + sn * outer);
        }
        MeshData mesh = bufferbuilder.build();
        BufferUploader.drawWithShader((MeshData)mesh);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        shader.clear();
    }
}

