/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import net.Gabou.projectatmosphere.client.HUDOverlayRenderer;
import net.Gabou.projectatmosphere.compat.ColdSweatCompat;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.TemperatureMod;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InstrumentUtils {
    public static void displayWind(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        WindVector wind = ForecastOrchestrator.getCurrentWind(key, level.getDayTime());
        String msg = "Wind: " + String.format("%.1fm/s at %.0f\u00b0", Float.valueOf(wind.baseSpeed()), Math.toDegrees(wind.angleRadians()));
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayTemperature(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        String msg = "Current temperature: " + String.format("%.1f\u00b0C", Float.valueOf(switch (CompatHandler.getActiveTemperatureMod()) {
            case TemperatureMod.TOUGH_AS_NAILS -> ToughAsNailsCompat.getLiveTemperatureTAN((ServerLevel)level, pos);
            case TemperatureMod.COLD_SWEAT -> ColdSweatCompat.getLiveTemperatureColdSweat((ServerLevel)level, pos);
            default -> InstrumentUtils.getForecastTemperature(level, pos);
        }));
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    private static float getForecastTemperature(Level level, BlockPos pos) {
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        return ForecastOrchestrator.getCurrentTemperature(key, level.getDayTime());
    }

    public static void displayHumidity(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        float humidity = ForecastOrchestrator.getCurrentHumidity(key, level.getDayTime());
        String msg = humidity < 0.01f ? "Humidity: Loading..." : "Current humidity: " + String.format("%.1f%%", Float.valueOf(humidity));
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayPressure(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        BlockPos pos = player.blockPosition();
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(pos, level), pos);
        double pressure = ForecastOrchestrator.getCurrentPressure(key, level.getDayTime());
        String msg = "Current pressure: " + String.format("%.1fhPa", pressure);
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }

    public static void displayStorm(Level level, Player player) {
        if (!level.isClientSide) {
            return;
        }
        String msg = level.isThundering() ? "Storm detected!" : (level.isRaining() ? "Rain detected." : "Skies clear.");
        HUDOverlayRenderer.showTemperatureOverlay(msg);
    }
}

