/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.util;

import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.async.BiomeSampler;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class WeatherSampler {
    public static Set<BiomeInstanceKey> sampleBiomesInRegion(SpawnRegion region, ServerLevel level) {
        HashSet<BiomeInstanceKey> keys = new HashSet<BiomeInstanceKey>();
        int baseX = region.x() << 4;
        int baseZ = region.z() << 4;
        for (int dx = 0; dx < 16; dx += 4) {
            for (int dz = 0; dz < 16; dz += 4) {
                BlockPos pos = new BlockPos(baseX + dx, level.getSeaLevel(), baseZ + dz);
                level.getBiome(pos).unwrapKey().ifPresent(key -> keys.add(new BiomeInstanceKey(key.location(), pos)));
            }
        }
        return keys;
    }

    public static Set<BiomeInstanceKey> sampleBiomesInArea(int centerX, int centerZ, int radius, ServerLevel level) {
        HashSet<BiomeInstanceKey> result = new HashSet<BiomeInstanceKey>();
        int step = 24;
        int radiusSq = radius * radius;
        BlockPos center = new BlockPos(centerX, level.getSeaLevel(), centerZ);
        BiomeSampler sampler = new BiomeSampler(level.getSeed(), level.registryAccess(), level.getChunkSource().getGenerator().getBiomeSource());
        for (int dx = -radius; dx <= radius; dx += step) {
            for (int dz = -radius; dz <= radius; dz += step) {
                if (dx * dx + dz * dz > radiusSq) continue;
                BlockPos pos = new BlockPos(centerX + dx, level.getSeaLevel(), centerZ + dz);
                ResourceLocation biomeId = sampler.getBiomeId(pos.getX(), pos.getY(), pos.getZ());
                BiomeInstanceKey bestMatch = null;
                double bestDistSq = Double.MAX_VALUE;
                List<BiomeInstanceKey> candidates = ForecastGenerator.getBiomeIndex().get(biomeId);
                if (candidates != null) {
                    for (BiomeInstanceKey known : candidates) {
                        double distSq;
                        if (!known.samplePos().closerThan((Vec3i)center, (double)radius) || !((distSq = known.samplePos().distSqr((Vec3i)pos)) < bestDistSq)) continue;
                        bestDistSq = distSq;
                        bestMatch = known;
                    }
                }
                if (bestMatch != null) {
                    result.add(bestMatch);
                    continue;
                }
                boolean tooClose = result.stream().anyMatch(existing -> existing.biomeType().equals((Object)biomeId) && existing.samplePos().distSqr((Vec3i)pos) < 10000.0);
                if (tooClose) continue;
                result.add(new BiomeInstanceKey(biomeId, pos));
            }
        }
        return result;
    }

    public static WeatherStats computeWeatherStats(Set<BiomeInstanceKey> keys, ServerLevel level, long tick) {
        float totalHumidity = 0.0f;
        float totalTemp = 0.0f;
        float totalPressure = 0.0f;
        float totalStormChance = 0.0f;
        WindVector totalWind = WindVector.fromBase(0.0f, 0.0f);
        int count = 0;
        HashMap<ResourceLocation, Integer> biomeFreq = new HashMap<ResourceLocation, Integer>();
        for (BiomeInstanceKey key : keys) {
            float humidity = ForecastOrchestrator.getCurrentHumidity(key, tick);
            float temperature = ForecastOrchestrator.getCurrentTemperature(key, tick);
            float pressure = ForecastOrchestrator.getCurrentPressure(key, tick);
            float stormChanceValue = ForecastOrchestrator.getCurrentStormChance(key, tick);
            WindVector wind = ForecastOrchestrator.getCurrentWind(key, tick);
            totalHumidity += humidity;
            totalTemp += temperature;
            totalPressure += pressure;
            totalWind = totalWind.add(wind);
            totalStormChance += stormChanceValue;
            biomeFreq.merge(key.biomeType(), 1, Integer::sum);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        BiomeInstanceKey dominantKey = keys.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType)).entrySet().stream().max(Map.Entry.comparingByValue(Comparator.comparingInt(List::size))).map(entry -> (BiomeInstanceKey)((List)entry.getValue()).get(0)).orElse(keys.iterator().next());
        return new WeatherStats(totalHumidity / (float)count, totalTemp / (float)count, totalPressure / (float)count, totalWind.divide(count), dominantKey.biomeType(), dominantKey.samplePos(), totalStormChance / (float)count);
    }

    public record WeatherStats(float humidity, float temperature, float pressure, WindVector windVector, ResourceLocation dominantBiome, BlockPos pos, float stormChance) {
    }
}

