/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.event;

import dev.nonamecrackers2.simpleclouds.api.common.cloud.region.ScAPICloudRegion;
import dev.nonamecrackers2.simpleclouds.api.common.event.CloudRegionNaturallySpawnEvent;
import dev.nonamecrackers2.simpleclouds.api.common.event.CloudRegionRemovedEvent;
import dev.nonamecrackers2.simpleclouds.api.common.event.CloudRegionTickEvent;
import dev.nonamecrackers2.simpleclouds.api.common.event.ModifyCloudSpeedEvent;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectatmosphere")
public class SimpleCloudsEventListener {
    @SubscribeEvent
    public static void onCloudRegionSpawn(CloudRegionNaturallySpawnEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CloudRegion region = (CloudRegion)event.getCloudRegion();
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Cloud region spawned naturally at {}, {}", (Object)Float.valueOf(region.getWorldX()), (Object)Float.valueOf(region.getWorldZ()));
        AtmosphereManager.queueAddCloudRegion(region);
    }

    @SubscribeEvent
    public static void onCloudRegionRemoved(CloudRegionRemovedEvent event) {
    }

    @SubscribeEvent
    public static void onCloudRegionTick(CloudRegionTickEvent event) {
        if (event.getLevel() == null || event.getLevel().f_46443_ || !SimpleCloudsCompat.getIsInit()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getLevel();
        ScAPICloudRegion region = event.getCloudRegion();
        int x = (int)region.getWorldX();
        int z = (int)region.getWorldZ();
        int y = serverLevel.m_5736_();
        BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(serverLevel, new BlockPos(x, y, z));
        WindVector.WindSample current = WindVector.getOrFallback(key);
        float currentSpeed = current.speedMps();
        float dirDeg = current.directionDeg();
        float stormFactor = ForecastOrchestrator.getCurrentStormChance(key, serverLevel.m_46467_());
        if (stormFactor > 0.15f) {
            float finalSpeed = SimpleCloudsEventListener.getFinalSpeed(stormFactor, currentSpeed, region);
            WindVector.set(key, finalSpeed, dirDeg);
        }
    }

    private static float getFinalSpeed(float stormFactor, float currentSpeed, ScAPICloudRegion region) {
        float stormBoost = Math.min(12.0f, 3.0f + stormFactor * 12.0f);
        float boosted = Math.max(currentSpeed, stormBoost);
        float tornadoBoost = 0.0f;
        for (TornadoInstance t : TornadoManager.getActiveTornadoes()) {
            double dz;
            CloudRegion cr = t.getCloudRegion();
            double dx = cr.getWorldX() - region.getWorldX();
            double dist = Math.sqrt(dx * dx + (dz = (double)(cr.getWorldZ() - region.getWorldZ())) * dz);
            if (!(dist <= (double)(t.radius + 150.0f))) continue;
            tornadoBoost = Math.max(tornadoBoost, 8.0f + t.getLevel().getMaxWindSpeed() * 0.5f);
        }
        float finalSpeed = Math.min(30.0f, boosted + tornadoBoost);
        return finalSpeed;
    }

    @SubscribeEvent
    public static void onModifyCloudSpeed(ModifyCloudSpeedEvent event) {
    }
}

