/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import com.Gabou.sereneseasonsplus.api.SSPApi;
import com.mojang.brigadier.CommandDispatcher;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.ServerCloudManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.command.DebugAtmoCommand;
import net.Gabou.projectatmosphere.command.SpawnCloudCommand;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.rainbows.RainbowRainBridge;
import net.Gabou.projectatmosphere.event.EventHandler;
import net.Gabou.projectatmosphere.gameplay.WindPhysics;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.humidity.HumidityCommand;
import net.Gabou.projectatmosphere.modules.hurricane.HurricaneManager;
import net.Gabou.projectatmosphere.modules.pressure.PressureCommand;
import net.Gabou.projectatmosphere.modules.snowstorm.SnowstormManager;
import net.Gabou.projectatmosphere.modules.temperature.command.TemperatureCommands;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.modules.wind.WindCommand;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.CloudRegionQueue;
import net.Gabou.projectatmosphere.util.ICloudRegionId;
import net.Gabou.projectatmosphere.util.WeatherType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;

public class AtmosphereManager {
    private static final Map<UUID, CompletableFuture<Void>> playerReadyMap = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private static final List<CloudRegion> cloudRegions = new ArrayList<CloudRegion>();
    public static boolean isInitialGenerationDone = false;
    private static final List<BlockPos> allCenterOfMap = new ArrayList<BlockPos>();
    private static int count;

    public static void onPlayerLogout(ServerLevel world, ServerPlayer player) {
        playerReadyMap.remove(player.m_20148_());
    }

    public static List<BlockPos> getAllCenterOfMap() {
        return allCenterOfMap;
    }

    public static void onServerStarting(ServerLevel world) {
        playerReadyMap.clear();
        isInitialGenerationDone = ForecastOrchestrator.onServerStart(world);
        count = 0;
        CloudRegionQueue.clear();
    }

    public static void onServerStopping(ServerLevel world) {
        ForecastOrchestrator.onServerStop(world);
        playerReadyMap.clear();
        isInitialGenerationDone = false;
        count = 0;
        CloudRegionQueue.clear();
    }

    public static void updateForecastAround(ServerLevel world, BlockPos center) {
        ProjectAtmosphere.LOGGER.info("Updating forecast Around");
        AsyncAtmosphereService.runWeather(() -> ForecastOrchestrator.updateForecast(world, center));
    }

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        TemperatureCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        HumidityCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PressureCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WindCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SpawnCloudCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DebugAtmoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onPlayerLogin(ServerLevel world, ServerPlayer player) {
        UUID uuid = player.m_20148_();
        CompletableFuture future = new CompletableFuture();
        playerReadyMap.put(uuid, future);
        world.m_7654_().execute(() -> {
            ForecastOrchestrator.onPlayerLogin(player, world);
            if (CompatHandler.isRainbowsLoaded()) {
                ServerCloudManager cloudManager = (ServerCloudManager)CloudManager.get((Level)world);
                RainbowRainBridge.sendSnapshot(player, world, (CloudGenerator)cloudManager.getCloudGenerator());
            }
            future.complete(null);
        });
    }

    public static CompletableFuture<Void> getPlayerReadyFuture(ServerPlayer player) {
        return playerReadyMap.computeIfAbsent(player.m_20148_(), uuid -> new CompletableFuture());
    }

    public static boolean isPlayerReady(UUID uuid) {
        CompletableFuture<Void> future = playerReadyMap.get(uuid);
        return future != null && future.isDone();
    }

    public static void onSwapProfiles(ServerLevel world) {
        ProjectAtmosphere.LOGGER.info("Swapping profiles and updating weather");
        AsyncAtmosphereService.runWeather(() -> ForecastOrchestrator.onSwapDay(world));
    }

    public static void onRegenerate(ServerLevel world) {
        ProjectAtmosphere.LOGGER.info("Regenerating weather data for all players");
        if (CompatHandler.isRainbowsLoaded()) {
            RainbowRainBridge.clear((ResourceKey<Level>)world.m_46472_());
        }
        AsyncAtmosphereService.runWeather(() -> {
            EventHandler.onRegenerate();
            CloudManager.get((Level)world).getCloudGenerator().removeAllClouds();
            TornadoManager.clearTornadoes();
            HurricaneManager.clearHurricanes();
            ForecastOrchestrator.clearAndRegenerate(world);
        });
        CloudRegionQueue.clear();
    }

    public static void onSeasonChange(ServerLevel world) {
        AtmosphereManager.onRegenerate(world);
    }

    public static void tick(ServerLevel level) {
        CloudRegionQueue.Entry entry;
        if (!ForecastOrchestrator.isRegenerating()) {
            ForecastOrchestrator.tick(level);
            WindPhysics.onServerTick(level);
            TornadoManager.tick((Level)level);
            HurricaneManager.tick(level);
            SnowstormManager.tick(level);
        } else {
            ForecastOrchestrator.tick(level);
        }
        if (count % 20 != 0) {
            CloudManager manager = CloudManager.get((Level)level);
            ArrayList activeRegions = new ArrayList(manager.getClouds());
            Set activeIds = activeRegions.stream().filter(r -> r instanceof ICloudRegionId).map(r -> ((ICloudRegionId)r).projectatmosphere$getId()).collect(Collectors.toSet());
            for (CloudRegion cloudRegion : new ArrayList<CloudRegion>(cloudRegions)) {
                ICloudRegionId id;
                if (!(cloudRegion instanceof ICloudRegionId) || activeIds.contains((id = (ICloudRegionId)cloudRegion).projectatmosphere$getId())) continue;
                AtmosphereManager.queueRemoveCloudRegion(cloudRegion);
            }
        }
        ++count;
        if (CloudRegionQueue.isEmpty()) {
            CloudRegionQueue.shuffle();
            return;
        }
        while ((entry = CloudRegionQueue.poll()) != null) {
            switch (entry.type()) {
                case ADD: {
                    AtmosphereManager.handleCloudRegionToQueue(level, entry.region());
                    break;
                }
                case REMOVE: {
                    AtmosphereManager.handleCloudRegionToRemove(level, entry.region());
                }
            }
        }
    }

    private static void handleCloudRegionToQueue(ServerLevel level, CloudRegion cloudRegion) {
        if (cloudRegions.contains(cloudRegion)) {
            return;
        }
        cloudRegions.add(cloudRegion);
        if (WeatherType.isRainy(cloudRegion.getCloudTypeId())) {
            SSPApi.getINSTANCE().onSimpleCloudsSpawned(level, ((ICloudRegionId)cloudRegion).projectatmosphere$getId());
        }
    }

    private static void handleCloudRegionToRemove(ServerLevel level, CloudRegion cloudRegion) {
        if (CloudManager.get((Level)level).getClouds().contains(cloudRegion) && !cloudRegions.contains(cloudRegion)) {
            return;
        }
        cloudRegions.remove(cloudRegion);
        if (WeatherType.isRainy(cloudRegion.getCloudTypeId())) {
            SSPApi.getINSTANCE().onCloudsDespawned(level, ((ICloudRegionId)cloudRegion).projectatmosphere$getId());
        }
    }

    public static List<CloudRegion> getCloudRegions() {
        return Collections.unmodifiableList(cloudRegions);
    }

    public static void queueAddCloudRegion(CloudRegion cloudRegion) {
        CloudRegionQueue.enqueueAdd(cloudRegion);
    }

    public static void queueRemoveCloudRegion(CloudRegion cloudRegion) {
        CloudRegionQueue.enqueueRemove(cloudRegion);
    }
}

