/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.util.RandomSource;

public final class AtmosphericStateRegistry {
    private static final Map<BiomeInstanceKey, RegionAtmosphereState> STATES = new ConcurrentHashMap<BiomeInstanceKey, RegionAtmosphereState>();
    private static final Map<BiomeInstanceKey, List<BiomeInstanceKey>> NEIGHBORS = new ConcurrentHashMap<BiomeInstanceKey, List<BiomeInstanceKey>>();
    private static final double NEIGHBOR_RADIUS_SQR = 65536.0;

    private AtmosphericStateRegistry() {
    }

    public static RegionAtmosphereState initializeState(BiomeInstanceKey key, BiomeForecast forecast) {
        RegionAtmosphereState state = RegionAtmosphereState.fromForecast(key, forecast);
        STATES.put(key, state);
        return state;
    }

    public static RegionAtmosphereState getState(BiomeInstanceKey key) {
        return STATES.get(key);
    }

    public static Collection<RegionAtmosphereState> getStates() {
        return STATES.values();
    }

    public static boolean isEmpty() {
        return STATES.isEmpty();
    }

    public static void clear() {
        STATES.clear();
        NEIGHBORS.clear();
    }

    public static void rebuildNeighbors() {
        ArrayList<BiomeInstanceKey> keys = new ArrayList<BiomeInstanceKey>(STATES.keySet());
        NEIGHBORS.clear();
        for (int i = 0; i < keys.size(); ++i) {
            BiomeInstanceKey a = (BiomeInstanceKey)keys.get(i);
            List listA = NEIGHBORS.computeIfAbsent(a, k -> new ArrayList());
            for (int j = i + 1; j < keys.size(); ++j) {
                BiomeInstanceKey b = (BiomeInstanceKey)keys.get(j);
                double dist = a.samplePos().m_203198_((double)b.samplePos().m_123341_(), (double)b.samplePos().m_123342_(), (double)b.samplePos().m_123343_());
                if (!(dist <= 65536.0)) continue;
                listA.add(b);
                NEIGHBORS.computeIfAbsent(b, k -> new ArrayList()).add(a);
            }
        }
    }

    public static List<BiomeInstanceKey> getNeighbors(BiomeInstanceKey key) {
        return NEIGHBORS.getOrDefault(key, List.of());
    }

    public static Optional<RegionAtmosphereState> getRandomState(RandomSource random) {
        if (STATES.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<RegionAtmosphereState> list = new ArrayList<RegionAtmosphereState>(STATES.values());
        return Optional.of((RegionAtmosphereState)list.get(random.m_188503_(list.size())));
    }

    public static RegionAtmosphereState findNearest(double x, double z) {
        RegionAtmosphereState nearest = null;
        double best = Double.MAX_VALUE;
        for (RegionAtmosphereState state : STATES.values()) {
            double dist = state.distanceTo(x, z);
            if (!(dist < best)) continue;
            best = dist;
            nearest = state;
        }
        return nearest;
    }

    public static List<RegionAtmosphereState> snapshot() {
        return Collections.unmodifiableList(new ArrayList<RegionAtmosphereState>(STATES.values()));
    }
}

