/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.Gabou.projectatmosphere.modules.atmosphere.AtmosphericStateRegistry;
import net.Gabou.projectatmosphere.modules.atmosphere.RegionAtmosphereState;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2;

public final class CycloneManager {
    private static final List<Cyclone> ACTIVE_CYCLONES = new ArrayList<Cyclone>();
    private static final long COOLDOWN_TICKS = 48000L;
    private static long lastSpawnTick = -48000L;
    private static long lastMidnightTick = -1L;

    private CycloneManager() {
    }

    public static void initialize(ServerLevel level) {
        ACTIVE_CYCLONES.clear();
        lastSpawnTick = level.m_46468_();
        lastMidnightTick = -1L;
        CycloneManager.spawnInitialCyclones(level);
    }

    public static void update(ServerLevel level) {
        if (AtmosphericStateRegistry.isEmpty()) {
            return;
        }
        long dayTime = level.m_46468_();
        if (dayTime % 24000L == 0L && lastMidnightTick != dayTime) {
            CycloneManager.onMidnight(level);
            lastMidnightTick = dayTime;
        }
        Iterator<Cyclone> it = ACTIVE_CYCLONES.iterator();
        while (it.hasNext()) {
            Cyclone cyclone = it.next();
            if (!cyclone.tick(level)) continue;
            it.remove();
        }
    }

    public static void onMidnight(ServerLevel level) {
        if (ACTIVE_CYCLONES.size() >= 4) {
            return;
        }
        long now = level.m_46468_();
        if (!CycloneManager.cooldownPassed(now)) {
            return;
        }
        CycloneManager.spawnCyclone(level);
    }

    private static boolean cooldownPassed(long now) {
        return now - lastSpawnTick >= 48000L;
    }

    private static void spawnInitialCyclones(ServerLevel level) {
        RandomSource random = level.f_46441_;
        int count = 3 + random.m_188503_(2);
        for (int i = 0; i < count; ++i) {
            CycloneManager.spawnCyclone(level);
        }
    }

    private static void spawnCyclone(ServerLevel level) {
        RandomSource random = level.f_46441_;
        Optional<RegionAtmosphereState> stateOpt = AtmosphericStateRegistry.getRandomState(random);
        if (stateOpt.isEmpty()) {
            return;
        }
        RegionAtmosphereState state = stateOpt.get();
        float radius = 180.0f + random.m_188501_() * 140.0f;
        float intensity = 0.4f + random.m_188501_() * 0.4f;
        float pressureDrop = 5.0f + random.m_188501_() * 10.0f;
        long lifetime = 24000L + (long)random.m_188503_(24000);
        ACTIVE_CYCLONES.add(new Cyclone(new Vec2((float)state.getPosition().m_123341_(), (float)state.getPosition().m_123343_()), radius, intensity, pressureDrop, lifetime));
        lastSpawnTick = level.m_46468_();
    }

    private static final class Cyclone {
        private Vec2 center;
        private float radius;
        private float intensity;
        private final float corePressureDrop;
        private long lifetimeTicks;

        private Cyclone(Vec2 center, float radius, float intensity, float corePressureDrop, long lifetimeTicks) {
            this.center = center;
            this.radius = radius;
            this.intensity = intensity;
            this.corePressureDrop = corePressureDrop;
            this.lifetimeTicks = lifetimeTicks;
        }

        private boolean tick(ServerLevel level) {
            this.applyEffects();
            this.drift(level);
            --this.lifetimeTicks;
            this.intensity *= 0.9995f;
            if (this.lifetimeTicks <= 0L || this.intensity < 0.05f) {
                return true;
            }
            this.radius = Mth.m_14036_((float)(this.radius + (this.intensity - 0.5f) * 0.8f), (float)120.0f, (float)420.0f);
            return false;
        }

        private void applyEffects() {
            List<RegionAtmosphereState> states = AtmosphericStateRegistry.snapshot();
            for (RegionAtmosphereState state : states) {
                double dz;
                double dx = (float)state.getPosition().m_123341_() - this.center.f_82470_;
                double distance = Math.sqrt(dx * dx + (dz = (double)((float)state.getPosition().m_123343_() - this.center.f_82471_)) * dz);
                if (distance > (double)this.radius) continue;
                float influence = (float)(1.0 - distance / (double)this.radius);
                state.adjustPressure(-this.corePressureDrop * influence * this.intensity);
                state.adjustHumidity(influence * this.intensity * 0.05f);
                state.adjustTemperature(-influence * this.intensity * 0.5f);
                state.setRainIntensity(Math.max(state.getRainIntensity(), influence * this.intensity));
                state.setCloudCover(Math.min(1.0f, state.getCloudCover() + influence * 0.25f));
            }
        }

        private void drift(ServerLevel level) {
            RegionAtmosphereState nearest = AtmosphericStateRegistry.findNearest(this.center.f_82470_, this.center.f_82471_);
            if (nearest == null) {
                return;
            }
            WindVector wind = nearest.getWind();
            if (wind == null) {
                return;
            }
            float speed = Math.max(0.05f, wind.baseSpeed() * 0.02f);
            float angle = wind.angleRadians();
            float dx = (float)Math.sin(angle) * speed;
            float dz = (float)Math.cos(angle) * speed;
            this.center = this.center.m_165910_(new Vec2(dx, dz));
        }
    }
}

