/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.atmosphere;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempConfig;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RegionAtmosphereState {
    private static final int DAILY_SLOTS = 240;
    private final BiomeInstanceKey key;
    private final float baseTemperature;
    private final float baseHumidity;
    private final float basePressure;
    private final float biomeSunlightMultiplier;
    private final float[] dailyTemperatureProfile;
    private final float[] dailyHumidityProfile;
    private final float[] dailyPressureProfile;
    private final float baselineMinTemp;
    private final float baselineMaxTemp;
    private float temperature;
    private float humidity;
    private float pressure;
    private WindVector wind;
    private float cloudCover;
    private float sunlight;
    private float rainIntensity;

    RegionAtmosphereState(BiomeInstanceKey key, BiomeForecast forecast, float baseTemperature, float baseHumidity, float basePressure, WindVector wind) {
        this.key = key;
        this.baseTemperature = baseTemperature;
        this.baseHumidity = RegionAtmosphereState.clampHumidity(baseHumidity);
        this.basePressure = basePressure;
        this.temperature = baseTemperature;
        this.humidity = RegionAtmosphereState.clampHumidity(baseHumidity);
        this.pressure = basePressure;
        this.wind = wind;
        this.biomeSunlightMultiplier = RegionAtmosphereState.computeBiomeSunlightMultiplier(key.biomeType());
        this.dailyTemperatureProfile = RegionAtmosphereState.initialiseDailyCurve(forecast.getTemperatureDay(), baseTemperature);
        this.dailyHumidityProfile = RegionAtmosphereState.initialiseDailyCurveScaled(forecast.getHumidityDay(), this.humidity, 100.0f);
        this.dailyPressureProfile = RegionAtmosphereState.initialiseDailyCurve(forecast.getPressureDay(), basePressure);
        float[] bounds = RegionAtmosphereState.computeTemperatureBounds(this.dailyTemperatureProfile, baseTemperature);
        this.baselineMinTemp = bounds[0];
        this.baselineMaxTemp = bounds[1];
    }

    public static RegionAtmosphereState fromForecast(BiomeInstanceKey key, BiomeForecast forecast) {
        float temperature = RegionAtmosphereState.averageDailyValue(forecast.getTemperature(), 15.0f);
        float humidity = RegionAtmosphereState.averageDailyValue(forecast.getHumidity(), 60.0f) / 100.0f;
        float pressure = RegionAtmosphereState.averageDailyValue(forecast.getPressure(), 1013.25f);
        WindVector wind = null;
        if (forecast.getWind() != null && forecast.getWind().length > 0) {
            wind = forecast.getWind()[0];
        }
        if (wind == null) {
            wind = WindVector.fromBase(1.0f, 0.0f);
        }
        return new RegionAtmosphereState(key, forecast, temperature, humidity, pressure, wind);
    }

    private static float averageDailyValue(@Nullable float[][] week, float fallback) {
        if (week == null || week.length == 0) {
            return fallback;
        }
        float sum = 0.0f;
        int count = 0;
        for (float[] day : week) {
            if (day == null || day.length == 0) continue;
            if (day.length == 1) {
                sum += day[0];
                ++count;
                continue;
            }
            sum += (day[0] + day[Math.min(1, day.length - 1)]) * 0.5f;
            ++count;
        }
        return count == 0 ? fallback : sum / (float)count;
    }

    public BiomeInstanceKey getKey() {
        return this.key;
    }

    public BlockPos getPosition() {
        return this.key.samplePos();
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void adjustTemperature(float delta) {
        this.temperature += delta;
    }

    public float getHumidity() {
        return this.humidity;
    }

    public float getHumidityPercent() {
        return this.humidity * 100.0f;
    }

    public void setHumidity(float humidity) {
        this.humidity = RegionAtmosphereState.clampHumidity(humidity);
    }

    public void adjustHumidity(float delta) {
        this.setHumidity(this.humidity + delta);
    }

    public float getPressure() {
        return this.pressure;
    }

    public void setPressure(float pressure) {
        this.pressure = Mth.m_14036_((float)pressure, (float)870.0f, (float)1085.0f);
    }

    public void adjustPressure(float delta) {
        this.setPressure(this.pressure + delta);
    }

    public WindVector getWind() {
        return this.wind;
    }

    public void setWind(WindVector wind) {
        this.wind = wind;
    }

    public float getWindStrength() {
        return this.wind == null ? 0.0f : Math.max(0.0f, this.wind.baseSpeed());
    }

    public float getCloudCover() {
        return this.cloudCover;
    }

    public void setCloudCover(float value) {
        this.cloudCover = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
    }

    public float getBiomeSunlightMultiplier() {
        return this.biomeSunlightMultiplier;
    }

    public float getSunlight() {
        return this.sunlight;
    }

    public void setSunlight(float sunlight) {
        this.sunlight = Mth.m_14036_((float)sunlight, (float)0.0f, (float)1.0f);
    }

    public float getRainIntensity() {
        return this.rainIntensity;
    }

    public void setRainIntensity(float rainIntensity) {
        this.rainIntensity = Math.max(0.0f, rainIntensity);
    }

    public void dampenRain(float factor) {
        this.rainIntensity = Math.max(0.0f, this.rainIntensity - factor);
    }

    public void recordDailySnapshot(long dayTime) {
        int slot = (int)(dayTime % 24000L / 100L);
        if (slot < 0 || slot >= this.dailyTemperatureProfile.length) {
            return;
        }
        this.dailyTemperatureProfile[slot] = this.temperature;
        this.dailyHumidityProfile[slot] = this.humidity;
        this.dailyPressureProfile[slot] = this.pressure;
    }

    public float[] getDailyTemperatureProfile() {
        return (float[])this.dailyTemperatureProfile.clone();
    }

    public float[] getDailyHumidityProfile() {
        return (float[])this.dailyHumidityProfile.clone();
    }

    public float[] getDailyPressureProfile() {
        return (float[])this.dailyPressureProfile.clone();
    }

    public void relaxTowardBase(float factor) {
        this.temperature += (this.baseTemperature - this.temperature) * factor;
        this.humidity += (this.baseHumidity - this.humidity) * factor;
        this.pressure += (this.basePressure - this.pressure) * factor;
        this.humidity = RegionAtmosphereState.clampHumidity(this.humidity);
        this.pressure = Mth.m_14036_((float)this.pressure, (float)870.0f, (float)1085.0f);
    }

    public double distanceTo(double x, double z) {
        double dx = (double)this.key.samplePos().m_123341_() - x;
        double dz = (double)this.key.samplePos().m_123343_() - z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public float getBaselineMinTemperature() {
        return this.baselineMinTemp;
    }

    public float getBaselineMaxTemperature() {
        return this.baselineMaxTemp;
    }

    public float getBaselineTemperatureSpan() {
        return Math.max(0.001f, this.baselineMaxTemp - this.baselineMinTemp);
    }

    public float getSunlightDrivenTemperature(float sunlightFactor) {
        float clamped = Mth.m_14036_((float)sunlightFactor, (float)0.0f, (float)1.0f);
        return Mth.m_14179_((float)clamped, (float)this.baselineMinTemp, (float)this.baselineMaxTemp);
    }

    private static float clampHumidity(float value) {
        return Mth.m_14036_((float)value, (float)0.0f, (float)1.2f);
    }

    private static float computeBiomeSunlightMultiplier(ResourceLocation biomeId) {
        float sum = 0.0f;
        int samples = 0;
        for (BiomeTempConfig.Season season : BiomeTempConfig.Season.values()) {
            BiomeTempConfig.Range range = BiomeTempConfig.getRange(biomeId, season);
            if (range == null) continue;
            sum += 0.5f * (range.minC() + range.maxC());
            ++samples;
        }
        if (samples == 0) {
            return 1.0f;
        }
        float mean = sum / (float)samples;
        float normalized = Mth.m_14036_((float)((mean + 20.0f) / 50.0f), (float)0.0f, (float)1.0f);
        return 0.6f + normalized * 0.8f;
    }

    private static float[] initialiseDailyCurve(@Nullable float[] source, float fallback) {
        if (source != null && source.length > 0) {
            return RegionAtmosphereState.resampleDailyCurve(source);
        }
        float[] arr = new float[240];
        Arrays.fill(arr, fallback);
        return arr;
    }

    private static float[] initialiseDailyCurveScaled(@Nullable float[] source, float normalizedFallback, float scale) {
        if (source != null && source.length > 0) {
            float[] resampled = RegionAtmosphereState.resampleDailyCurve(source);
            for (int i = 0; i < resampled.length; ++i) {
                resampled[i] = Mth.m_14036_((float)(resampled[i] / scale), (float)0.0f, (float)1.2f);
            }
            return resampled;
        }
        float[] arr = new float[240];
        Arrays.fill(arr, Mth.m_14036_((float)normalizedFallback, (float)0.0f, (float)1.2f));
        return arr;
    }

    private static float[] resampleDailyCurve(float[] source) {
        float[] target = new float[240];
        if (source.length == 240) {
            System.arraycopy(source, 0, target, 0, 240);
            return target;
        }
        float maxIndex = (float)source.length - 1.0f;
        for (int i = 0; i < 240; ++i) {
            float position = maxIndex * (float)i / 239.0f;
            target[i] = RegionAtmosphereState.interpolate(source, position);
        }
        return target;
    }

    private static float interpolate(float[] source, float position) {
        int lower = (int)Math.floor(position);
        int upper = Math.min(source.length - 1, lower + 1);
        float t = position - (float)lower;
        float lowerValue = source[lower];
        float upperValue = source[upper];
        return lowerValue + (upperValue - lowerValue) * t;
    }

    private static float[] computeTemperatureBounds(float[] profile, float fallback) {
        if (profile == null || profile.length == 0) {
            return new float[]{fallback - 2.0f, fallback + 2.0f};
        }
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (float value : profile) {
            if (Float.isNaN(value)) continue;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        if (!Float.isFinite(min) || !Float.isFinite(max)) {
            return new float[]{fallback - 2.0f, fallback + 2.0f};
        }
        if (min == max) {
            min -= 2.0f;
            max += 2.0f;
        }
        return new float[]{min, max};
    }
}

