/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.sandStorm;

import com.BreadRes.desertstormwarming.logic.SandstormManager;
import com.BreadRes.desertstormwarming.logic.SandstormPhase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.wind.WindMath;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class SandStormAPI {
    private static final List<BiomeInstanceKey> scheduledStormBiome = new ArrayList<BiomeInstanceKey>();

    private SandStormAPI() {
    }

    public static SandstormPhase getSandstormPhase() {
        return SandstormManager.getPhase();
    }

    public static List<BiomeInstanceKey> getScheduledStormBiome() {
        return scheduledStormBiome;
    }

    public static void startSandstorm(SandstormPhase phase, BiomeInstanceKey biomeInstanceKey) {
        SandstormManager.start((SandstormPhase)phase);
        scheduledStormBiome.add(biomeInstanceKey);
    }

    public static void stopSandstorm(BiomeInstanceKey biomeInstanceKey) {
        SandstormManager.stop();
        scheduledStormBiome.remove(biomeInstanceKey);
    }

    public static boolean isSandstormActive() {
        return SandstormManager.isActive();
    }

    public static void setPhase(SandstormPhase phase) {
        SandstormManager.setPhase((SandstormPhase)phase);
    }

    public static void onSandStormManagerTick(Level level) {
    }

    public static void maybeMoveSand(Level level, BlockPos sourcePos, WindVector wind) {
        BlockPos offset = WindMath.getWindOffset(wind);
        BlockPos target = sourcePos.m_121955_((Vec3i)offset);
        if (level.m_46859_(target)) {
            BlockState sand = level.m_8055_(sourcePos);
            level.m_7731_(sourcePos, Blocks.f_50016_.m_49966_(), 3);
            level.m_7731_(target, sand, 3);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), (double)sourcePos.m_123341_() + 0.5, (double)sourcePos.m_123342_() + 0.5, (double)sourcePos.m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.05);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)target.m_123341_() + 0.5, (double)target.m_123342_() + 1.0, (double)target.m_123343_() + 0.5, 5, 0.2, 0.1, 0.2, 0.01);
            }
        }
    }

    public static void blowSandInBiome(ServerLevel level, BiomeInstanceKey key, WindVector wind) {
        BlockPos center = key.samplePos();
        int radiusXZ = 8;
        int height = 4;
        ArrayList sandBlocks = new ArrayList();
        BlockPos.m_121990_((BlockPos)new BlockPos(center.m_123341_() - radiusXZ, 0, center.m_123343_() - radiusXZ), (BlockPos)new BlockPos(center.m_123341_() + radiusXZ, 0, center.m_123343_() + radiusXZ)).map(pos -> {
            int surfaceY = Math.abs(level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()));
            return new BlockPos(pos.m_123341_(), surfaceY - 1, pos.m_123343_());
        }).filter(pos -> {
            BlockState state = level.m_8055_(pos);
            return state.m_60713_(Blocks.f_49992_) && level.m_46859_(pos.m_7494_());
        }).forEach(pos -> sandBlocks.add(pos.m_7949_()));
        if (sandBlocks.isEmpty()) {
            return;
        }
        int countToMove = Mth.m_14045_((int)(10 + level.f_46441_.m_188503_(21)), (int)1, (int)sandBlocks.size());
        Collections.shuffle(sandBlocks);
        for (int i = 0; i < countToMove; ++i) {
            SandStormAPI.maybeMoveSand((Level)level, (BlockPos)sandBlocks.get(i), wind);
        }
    }
}

