/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.snowstorm;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import java.util.ArrayList;
import java.util.List;
import net.Gabou.projectatmosphere.modules.snowstorm.SnowStorm;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.fml.ModList;

public class SnowstormManager {
    private static final List<SnowStorm> affectedRegions = new ArrayList<SnowStorm>();
    private static final String[] TEMPERATURE_MODS = new String[]{"toughasnails", "legendarysurvivaloverhaul", "coldsweat"};

    public static void startSnowstorm(int intensity, CloudRegion region) {
        affectedRegions.add(new SnowStorm(intensity, region));
    }

    public static void stopSnowstorm(SnowStorm snowstorm) {
        affectedRegions.remove(snowstorm);
    }

    public static int getSnowStormIntensity(ChunkPos pos) {
        SpawnRegion region = new SpawnRegion(pos.m_45608_(), pos.m_45605_(), 16);
        return affectedRegions.stream().filter(storm -> storm.getCloudRegion().intersects(region)).mapToInt(SnowStorm::getIntensity).max().orElse(0);
    }

    public static boolean isSnowStormAt(ChunkPos pos) {
        SpawnRegion region = new SpawnRegion(pos.m_45608_(), pos.m_45605_(), 16);
        return affectedRegions.stream().anyMatch(storm -> storm.getCloudRegion().intersects(region));
    }

    public static void tick(ServerLevel level) {
        for (SnowStorm snow : affectedRegions) {
            for (ServerPlayer player : level.m_6907_()) {
                BlockPos pos = player.m_20183_();
                if (!snow.getCloudRegion().intersects(new SpawnRegion(pos.m_123341_(), pos.m_123342_(), 5))) continue;
                SnowstormManager.applyEffects(player, snow.getIntensity());
            }
        }
    }

    private static void applyEffects(ServerPlayer player, int forecast) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false));
        SnowstormManager.triggerTemperatureEffect(player);
        player.m_5661_((Component)Component.m_237113_((String)("Snow forecast: " + forecast + " blocks")), true);
    }

    private static boolean isTemperatureModLoaded() {
        for (String mod : TEMPERATURE_MODS) {
            if (!ModList.get().isLoaded(mod)) continue;
            return true;
        }
        return false;
    }

    private static void triggerTemperatureEffect(ServerPlayer player) {
        if (SnowstormManager.isTemperatureModLoaded()) {
            if (player.m_21230_() > 12) {
                return;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, false, false));
        }
    }
}

