/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.storm;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public final class GlobalStormHistoryData
extends SavedData {
    private static final String STORAGE_ID = "project_atmosphere_storm_history";
    private int lastSevereDay = Integer.MIN_VALUE;
    private int recentSevereCount = 0;
    private int cooldownDaysRemaining = 0;

    public int getLastSevereDay() {
        return this.lastSevereDay;
    }

    public int getRecentSevereCount() {
        return this.recentSevereCount;
    }

    public int getCooldownDaysRemaining() {
        return this.cooldownDaysRemaining;
    }

    public void setCooldownDaysRemaining(int days) {
        this.cooldownDaysRemaining = days;
    }

    public void recordSevere(int currentDay) {
        this.recentSevereCount = this.lastSevereDay == currentDay - 1 ? ++this.recentSevereCount : 1;
        this.lastSevereDay = currentDay;
    }

    public void resetIfCalm(int currentDay) {
        if (currentDay != this.lastSevereDay) {
            this.recentSevereCount = 0;
        }
    }

    public static GlobalStormHistoryData get(ServerLevel level) {
        return (GlobalStormHistoryData)level.m_8895_().m_164861_(GlobalStormHistoryData::load, GlobalStormHistoryData::new, STORAGE_ID);
    }

    public static GlobalStormHistoryData load(CompoundTag tag) {
        GlobalStormHistoryData data = new GlobalStormHistoryData();
        data.lastSevereDay = tag.m_128451_("lastSevereDay");
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("lastSevereDay", this.lastSevereDay);
        return tag;
    }
}

