/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.temperature.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public final class BiomeTempUserConfig {
    private static final String FILE_NAME = "biome_temps.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private BiomeTempUserConfig() {
    }

    public static void load() {
        try {
            JsonObject biomes;
            Path configDir = FMLPaths.CONFIGDIR.get().resolve("projectatmosphere");
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path file = configDir.resolve(FILE_NAME);
            if (Files.notExists(file, new LinkOption[0])) {
                BiomeTempUserConfig.writeTemplate(file);
                ProjectAtmosphere.LOGGER.info("Created biome temperature config template at {}", (Object)file);
                return;
            }
            String raw = Files.readString(file, StandardCharsets.UTF_8);
            if (raw.isBlank()) {
                ProjectAtmosphere.LOGGER.warn("Biome temperature config is empty: {}", (Object)file);
                return;
            }
            JsonObject root = JsonParser.parseString((String)raw).getAsJsonObject();
            JsonObject jsonObject = biomes = root.has("biomes") && root.get("biomes").isJsonObject() ? root.getAsJsonObject("biomes") : null;
            if (biomes == null) {
                ProjectAtmosphere.LOGGER.warn("No 'biomes' object found in {} \u2014 nothing to load.", (Object)file);
                return;
            }
            int applied = 0;
            for (Map.Entry e : biomes.entrySet()) {
                String key = (String)e.getKey();
                ResourceLocation id = BiomeTempUserConfig.parseId(key);
                if (id == null) {
                    ProjectAtmosphere.LOGGER.warn("Skipping invalid biome id in config: {}", (Object)key);
                    continue;
                }
                if (!((JsonElement)e.getValue()).isJsonObject()) {
                    ProjectAtmosphere.LOGGER.warn("Skipping biome {} because its value is not an object.", (Object)key);
                    continue;
                }
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                RangeOrAll ro = BiomeTempUserConfig.parseRanges(obj);
                if (ro == null) {
                    ProjectAtmosphere.LOGGER.warn("Biome {} entry missing seasons or 'all' range \u2014 skipped.", (Object)key);
                    continue;
                }
                BiomeTempConfig.Range[] ranges = ro.asSeasonArray();
                BiomeTempConfig.Season[] seasons = BiomeTempConfig.Season.values();
                for (int i = 0; i < seasons.length; ++i) {
                    BiomeTempConfig.Range r = ranges[i];
                    if (r == null) continue;
                    BiomeTempConfig.SEASON_RANGES.get((Object)seasons[i]).put(id, r);
                    BiomeTempConfig.SEASON_CLAMPS.get((Object)seasons[i]).put(id, BiomeTempConfig.deriveDaily(r));
                }
                ++applied;
            }
            if (applied > 0) {
                ProjectAtmosphere.LOGGER.info("Applied {} biome temperature override(s) from {}", (Object)applied, (Object)file);
            } else {
                ProjectAtmosphere.LOGGER.info("No biome temperature overrides were applied from {}", (Object)file);
            }
        }
        catch (Exception ex) {
            ProjectAtmosphere.LOGGER.error("Failed loading biome temperature config", (Throwable)ex);
        }
    }

    private static ResourceLocation parseId(String s) {
        if (s == null) {
            return null;
        }
        ResourceLocation parsed = ResourceLocation.m_135820_((String)(s = s.trim()));
        if (parsed != null) {
            return parsed;
        }
        try {
            return ResourceLocation.withDefaultNamespace((String)s);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void writeTemplate(Path file) throws IOException {
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap biomes = new HashMap();
        HashMap sample1 = new HashMap();
        HashMap<String, Float> winter = new HashMap<String, Float>();
        winter.put("min", Float.valueOf(-10.0f));
        winter.put("max", Float.valueOf(5.0f));
        HashMap<String, Float> spring = new HashMap<String, Float>();
        spring.put("min", Float.valueOf(0.0f));
        spring.put("max", Float.valueOf(15.0f));
        HashMap<String, Float> summer = new HashMap<String, Float>();
        summer.put("min", Float.valueOf(10.0f));
        summer.put("max", Float.valueOf(25.0f));
        HashMap<String, Float> autumn = new HashMap<String, Float>();
        autumn.put("min", Float.valueOf(0.0f));
        autumn.put("max", Float.valueOf(15.0f));
        sample1.put("winter", winter);
        sample1.put("spring", spring);
        sample1.put("summer", summer);
        sample1.put("autumn", autumn);
        biomes.put("minecraft:plains", sample1);
        HashMap sample2 = new HashMap();
        HashMap<String, Float> all = new HashMap<String, Float>();
        all.put("min", Float.valueOf(20.0f));
        all.put("max", Float.valueOf(30.0f));
        sample2.put("all", all);
        biomes.put("examplemod:hot_biome", sample2);
        root.put("_note", "Add your biome ids under 'biomes'. Provide either per-season min/max or an 'all' min/max to apply to all seasons. Temperatures are in Celsius.");
        root.put("biomes", biomes);
        try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            w.write(GSON.toJson(root));
            w.write(System.lineSeparator());
        }
    }

    private static RangeOrAll parseRanges(JsonObject obj) {
        BiomeTempConfig.Range all = BiomeTempUserConfig.parseRange(obj, "all");
        if (all != null) {
            return RangeOrAll.all(all);
        }
        BiomeTempConfig.Range w = BiomeTempUserConfig.parseRange(obj, "winter");
        BiomeTempConfig.Range sp = BiomeTempUserConfig.parseRange(obj, "spring");
        BiomeTempConfig.Range su = BiomeTempUserConfig.parseRange(obj, "summer");
        BiomeTempConfig.Range au = BiomeTempUserConfig.parseRange(obj, "autumn");
        if (w == null || sp == null || su == null || au == null) {
            return null;
        }
        return RangeOrAll.perSeason(w, sp, su, au);
    }

    private static BiomeTempConfig.Range parseRange(JsonObject parent, String key) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            return null;
        }
        JsonObject o = parent.getAsJsonObject(key);
        if (!o.has("min") || !o.has("max")) {
            return null;
        }
        try {
            float min = o.get("min").getAsFloat();
            float max = o.get("max").getAsFloat();
            return new BiomeTempConfig.Range(min, max);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private record RangeOrAll(BiomeTempConfig.Range winter, BiomeTempConfig.Range spring, BiomeTempConfig.Range summer, BiomeTempConfig.Range autumn) {
        static RangeOrAll all(BiomeTempConfig.Range r) {
            return new RangeOrAll(r, r, r, r);
        }

        static RangeOrAll perSeason(BiomeTempConfig.Range w, BiomeTempConfig.Range sp, BiomeTempConfig.Range su, BiomeTempConfig.Range au) {
            return new RangeOrAll(w, sp, su, au);
        }

        BiomeTempConfig.Range[] asSeasonArray() {
            return new BiomeTempConfig.Range[]{this.winter, this.spring, this.summer, this.autumn};
        }
    }
}

