/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.GlassDamageManager;
import net.Gabou.projectatmosphere.modules.tornado.TornadoLevel;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TornadoInstance {
    private static final int DEBRIS_RANGE_EXTENSION = 5;
    public static final double AMBIENT_WIND_INFLUENCE_EXTENSION = 15.0;
    public static final double WIND_SPEED_SCALING_FACTOR = 0.05;
    public static final double WIND_EFFECT_VERTICAL_MAX_OFFSET = 50.0;
    public static final double WIND_EFFECT_VERTICAL_MIN_OFFSET = -5.0;
    public Vec3 position;
    public final long spawnTime;
    public final float radius;
    public final WindVector wind;
    private final CloudRegion cloudRegion;
    private float angularSpeed = 0.15f;
    private long lastDemolitionCheck = 0L;
    private final long demolitionIntervalMs = 1000L;
    private final long ambientWindIntervalMs = 2000L;
    private long lastAmbientWindCheck = 0L;
    private final TornadoLevel level;
    private int _destroyCursor = 0;

    public TornadoLevel getLevel() {
        return this.level;
    }

    public CloudRegion getCloudRegion() {
        return this.cloudRegion;
    }

    public double getSuctionRadius() {
        return this.level.getBaseDamage() * 2.0;
    }

    public double getDamageMultiplier() {
        return this.level.getBaseDamage();
    }

    public TornadoInstance(Vec3 position, float radius, WindVector wind, CloudRegion cloudRegion) {
        this(position, radius, wind, 0.05f, cloudRegion);
    }

    public TornadoInstance(Vec3 position, float radius, WindVector wind, float angularSpeed, CloudRegion cloudRegion) {
        this.position = position;
        this.radius = radius;
        this.wind = wind;
        this.angularSpeed = angularSpeed;
        this.spawnTime = System.currentTimeMillis();
        this.level = TornadoLevel.fromWindSpeed(wind.baseSpeed());
        this.cloudRegion = cloudRegion;
    }

    public float getLifetimeSeconds() {
        return (float)(System.currentTimeMillis() - this.spawnTime) / 1000.0f;
    }

    public float getTwist() {
        long elapsedMs = System.currentTimeMillis() - this.spawnTime;
        float elapsedTicks = (float)elapsedMs / 100.0f;
        return Mth.m_14036_((float)(elapsedTicks * this.angularSpeed), (float)0.5f, (float)5.0f);
    }

    public void tick(Level level) {
        boolean demolitionDue;
        if (level.f_46443_) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean ambientDue = now - this.lastAmbientWindCheck >= 2000L;
        boolean bl = demolitionDue = now - this.lastDemolitionCheck >= 1000L;
        if (ambientDue || demolitionDue) {
            AsyncAtmosphereService.runStorm(() -> {
                try {
                    if (ambientDue) {
                        this.lastAmbientWindCheck = now;
                        this.applyAmbientWind(level);
                    }
                    if (demolitionDue) {
                        this.lastDemolitionCheck = now;
                        this.demolishBlocks((ServerLevel)level);
                        level.m_7654_().execute(() -> this.playDemolitionSound(level));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void applyAmbientWind(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double influence = (double)this.radius + 15.0;
        double minY = this.position.f_82480_ + -5.0;
        double maxY = this.position.f_82480_ + 50.0;
        AABB box = new AABB(this.position.f_82479_ - influence, minY, this.position.f_82481_ - influence, this.position.f_82479_ + influence, maxY, this.position.f_82481_ + influence);
        double ambientSpeed = Math.max(0.0, (double)this.wind.gustSpeed()) * 0.05;
        double ax = Math.cos(this.wind.angleRadians()) * ambientSpeed;
        double az = Math.sin(this.wind.angleRadians()) * ambientSpeed;
        for (Entity entity : serverLevel.m_45933_(null, box)) {
            double dz;
            double dx = this.position.f_82479_ - entity.m_20185_();
            double distSq = dx * dx + (dz = this.position.f_82481_ - entity.m_20189_()) * dz;
            double dist = Math.sqrt(distSq);
            double nx = dist > 1.0E-4 ? dx / dist : 0.0;
            double nz = dist > 1.0E-4 ? dz / dist : 0.0;
            double suctionRadius = Math.max(4.0, this.getSuctionRadius());
            double proximity = Math.max(0.0, 1.0 - Math.min(dist, suctionRadius) / suctionRadius);
            double swirlDirX = -nz;
            double swirlDirZ = nx;
            double baseMag = 0.06 + (double)this.getLevel().getMaxWindSpeed() * 0.02;
            double suctionMag = baseMag * 2.0 * proximity;
            double swirlMag = baseMag * 1.5 * Math.sqrt(proximity);
            double vx = ax + nx * suctionMag + swirlDirX * swirlMag;
            double vz = az + nz * suctionMag + swirlDirZ * swirlMag;
            double vy = 0.02 * proximity * (1.0 + (double)this.getLevel().getMaxWindSpeed() * 0.02);
            entity.m_5997_(vx, vy, vz);
            if (!(entity instanceof Player)) continue;
            entity.f_19864_ = true;
        }
    }

    private void demolishBlocks(ServerLevel level) {
        BlockPos center = BlockPos.m_274446_((Position)this.position);
        int intRadius = Mth.m_14167_((float)this.radius);
        double outerSq = (this.radius + 5.0f) * (this.radius + 5.0f);
        double innerSq = this.radius * this.radius;
        double band = Math.max(1.0, outerSq - innerSq);
        double invBand = 1.0 / band;
        BlockPos min = center.m_7918_(-intRadius - 5, 0, -intRadius - 5);
        BlockPos max = center.m_7918_(intRadius + 5, 3 + intRadius, intRadius + 5);
        LongArrayList toDestroy = new LongArrayList(2048);
        LongArrayList toDestroyGlass = new LongArrayList(2048);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            if (!level.m_46749_(pos)) continue;
            try {
                BlockState state;
                LevelChunk chunk = level.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, false);
                if (chunk == null || (state = chunk.m_8055_(pos)).m_60795_()) continue;
                double distSq = pos.m_123331_((Vec3i)center);
                if (state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_)) {
                    toDestroy.add(pos.m_121878_());
                    continue;
                }
                if (!AtmosphereUtils.isGlass(state) || distSq > outerSq) continue;
                float pMax = 0.35f;
                double t = Mth.m_14008_((double)((outerSq - distSq) * invBand), (double)0.0, (double)1.0);
                float p = (float)(t * (double)0.35f);
                if (!(level.f_46441_.m_188501_() < p)) continue;
                toDestroyGlass.add(pos.m_121878_());
            }
            catch (Throwable throwable) {}
        }
        int perTick = 256;
        this._destroyCursor = 0;
        if (!toDestroy.isEmpty()) {
            AsyncAtmosphereService.runOnMainThread(() -> this.processLeafLogDestruction(level, toDestroy, 256));
        }
        if (!toDestroyGlass.isEmpty()) {
            GlassDamageManager.damageGlass(level, toDestroyGlass);
        }
    }

    private void processLeafLogDestruction(ServerLevel level, LongArrayList list, int perTick) {
        if (this._destroyCursor >= list.size()) {
            this._destroyCursor = 0;
            return;
        }
        int end = Math.min(this._destroyCursor + perTick, list.size());
        for (int i = this._destroyCursor; i < end; ++i) {
            BlockState state;
            BlockPos pos = BlockPos.m_122022_((long)list.getLong(i));
            if (!level.m_46749_(pos) || !(state = level.m_8055_(pos)).m_204336_(BlockTags.f_13035_) && !state.m_204336_(BlockTags.f_13106_)) continue;
            level.m_46961_(pos, false);
        }
        this._destroyCursor = end;
        if (this._destroyCursor < list.size()) {
            level.m_7654_().execute(() -> this.processLeafLogDestruction(level, list, perTick));
        } else {
            this._destroyCursor = 0;
        }
    }

    private void playDemolitionSound(Level level) {
        BlockPos center = BlockPos.m_274446_((Position)this.position);
        level.m_7785_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), SoundEvents.f_11913_, SoundSource.WEATHER, 2.0f, 0.5f + level.m_213780_().m_188501_() * 0.4f, false);
    }
}

