/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;

public final class TornadoSpawnScheduler {
    private static final int MAX_TORNADOES = 3;
    private static final long MINUTES_TO_TICKS = 1200L;
    private static final long INITIAL_DELAY_TICKS = 36000L;
    private static final long SLOT_INTERVAL_TICKS = 24000L;
    private static final long COOLDOWN_TICKS = 72000L;
    private static final long[] slotReadyTicks = new long[3];

    private TornadoSpawnScheduler() {
    }

    public static boolean isSlotAvailable(long nowTick) {
        if (TornadoManager.getActiveTornadoes().size() >= 3) {
            return false;
        }
        for (long ready : slotReadyTicks) {
            if (nowTick < ready) continue;
            return true;
        }
        return false;
    }

    public static void recordSpawn(long nowTick) {
        for (int i = 0; i < slotReadyTicks.length; ++i) {
            if (nowTick < slotReadyTicks[i]) continue;
            TornadoSpawnScheduler.slotReadyTicks[i] = nowTick + 72000L;
            break;
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TornadoSpawnScheduler.slotReadyTicks[i] = 36000L + (long)i * 24000L;
        }
    }
}

