/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.network;

import java.util.function.Supplier;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncWindPacket {
    private final BiomeInstanceKey key;
    private final float baseSpeed;
    private final float gustSpeed;
    private final float directionDeg;
    private final long gustEndTick;

    public SyncWindPacket(BiomeInstanceKey key, float baseSpeed, float gustSpeed, float directionDeg, long gustEndTick) {
        this.key = key;
        this.baseSpeed = baseSpeed;
        this.gustSpeed = gustSpeed;
        this.directionDeg = directionDeg;
        this.gustEndTick = gustEndTick;
    }

    public SyncWindPacket(FriendlyByteBuf buf) {
        this.key = BiomeInstanceKey.fromString(buf.m_130277_());
        this.baseSpeed = buf.readFloat();
        this.gustSpeed = buf.readFloat();
        this.directionDeg = buf.readFloat();
        this.gustEndTick = buf.readLong();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.key.toString());
        buf.writeFloat(this.baseSpeed);
        buf.writeFloat(this.gustSpeed);
        buf.writeFloat(this.directionDeg);
        buf.writeLong(this.gustEndTick);
    }

    public static SyncWindPacket decode(FriendlyByteBuf buf) {
        return new SyncWindPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> WindVector.set(this.key, this.baseSpeed + this.gustSpeed, this.directionDeg));
        ctx.get().setPacketHandled(true);
    }
}

