/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.api;

import dev.nonamecrackers2.simpleclouds.common.cloud.CloudType;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.WeatherType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class AtmoApi {
    private static final AtmoApi INSTANCE = new AtmoApi();

    private AtmoApi() {
    }

    public static AtmoApi getInstance() {
        return INSTANCE;
    }

    public BiomeForecast getWeatherForecast(ServerLevel level, BlockPos pos, ForecastType forecastType) {
        return ForecastGenerator.getClosestValidForecast(AtmosphereUtils.getBiomeKey(level, pos), forecastType);
    }

    public Object getCurrentWeather(ServerLevel level, BlockPos pos) {
        return CloudManager.get((Level)level).getCloudTypeAtPosition((float)pos.m_123341_(), (float)pos.m_123343_());
    }

    public boolean isRainingOrThundering(ServerLevel level, BlockPos pos) {
        return WeatherType.isRainy(((CloudType)CloudManager.get((Level)level).getCloudTypeAtPosition((float)pos.m_123341_(), (float)pos.m_123343_()).getKey()).id());
    }

    public Object getWeatherAlerts(ServerLevel level, BlockPos pos) {
        return null;
    }

    public Object getWeatherHistory(ServerLevel level, BlockPos pos) {
        return null;
    }

    @Deprecated(since="0.5.4.0", forRemoval=true)
    public boolean isRainningAt(ServerLevel level, BlockPos pos) {
        return CloudManager.get((Level)level).isRainingAt(pos);
    }

    public boolean isRainningLevel(ServerLevel level, BlockPos pos) {
        return CloudManager.get((Level)level).getClouds().stream().anyMatch(cloud -> WeatherType.isRainy(cloud.getCloudTypeId()));
    }
}

