/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.nonamecrackers2.simpleclouds.client.mesh.generator.CloudMeshGenerator;
import dev.nonamecrackers2.simpleclouds.client.renderer.CloudImageRenderer;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ShaderSnapshot {
    public static void captureFramebuffer(String fileName) {
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85441_();
        int height = mc.m_91268_().m_85442_();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        ShaderSnapshot.saveBufferAsPNG(buffer, width, height, fileName);
    }

    public static void captureTexture(int texId, int width, int height, String fileName) {
        RenderSystem.bindTexture((int)texId);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        ShaderSnapshot.saveBufferAsPNG(buffer, width, height, fileName);
        CloudMeshGenerator generator = SimpleCloudsRenderer.getInstance().getMeshGenerator();
        File path = new File(Minecraft.m_91087_().f_91069_, "cloud_dumps");
        if (!path.exists()) {
            path.mkdirs();
        }
        CloudImageRenderer renderer = CloudImageRenderer.basicIsometric((File)path, (CloudMeshGenerator)generator);
        renderer.setBgCol(0.0f, 0.0f, 0.0f);
        renderer.initialize();
        renderer.render();
        renderer.exportToRenderedImage(msg -> Minecraft.m_91087_().f_91074_.m_213846_(msg));
        renderer.finalize();
        renderer.close();
    }

    private static void saveBufferAsPNG(ByteBuffer buffer, int width, int height, String fileName) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (x + y * width) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                int argb = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, height - y - 1, argb);
            }
        }
        try {
            File out = new File(Minecraft.m_91087_().f_91069_, fileName + ".png");
            ImageIO.write((RenderedImage)image, "PNG", out);
            System.out.println("[ShaderSnapshot] Saved: " + out.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

