/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import java.util.EnumSet;
import net.Gabou.projectatmosphere.api.CropStressEvent;
import net.Gabou.projectatmosphere.api.CropStressType;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CropStressManager {
    private static final float DROUGHT_THRESHOLD = 15.0f;
    private static final float OVERWATER_THRESHOLD = 90.0f;
    private static final float HEAT_THRESHOLD = 35.0f;
    private static final float COLD_THRESHOLD = 0.0f;

    public static EnumSet<CropStressType> evaluate(ServerLevel level, BlockPos pos) {
        BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, pos);
        long tick = level.m_46467_();
        float humidity = ForecastOrchestrator.getCurrentHumidity(key, tick);
        float temperature = ForecastOrchestrator.getCurrentTemperature(key, tick);
        EnumSet<CropStressType> stresses = EnumSet.noneOf(CropStressType.class);
        if (humidity < 15.0f) {
            stresses.add(CropStressType.DROUGHT);
        }
        if (humidity > 90.0f) {
            stresses.add(CropStressType.OVERWATERED);
        }
        if (temperature > 35.0f) {
            stresses.add(CropStressType.HEAT);
        }
        if (temperature < 0.0f) {
            stresses.add(CropStressType.COLD);
        }
        if (!stresses.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new CropStressEvent(level, pos, stresses, temperature, humidity));
        }
        return stresses;
    }
}

