/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.core;

import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class CloudLibrary {
    private static final Random RANDOM = new Random();
    private static final String[] SNOWSTORM_CLOUDS = new String[]{"snow", "nimbostratus", "severe_nimbostratus"};
    private static final Set<String> SNOW_CLOUDS = Set.of(SNOWSTORM_CLOUDS);
    private static final Set<String> THUNDER_CLOUDS = Set.of("cumulonimbus", "severe_cumulonimbus", "tsegrus", "dense_tsegrus", "dark_wall", "custom_cumulonimbus");
    private static final String[] THUNDER_LOW_CLOUDS = new String[]{"cumulonimbus", "tsegrus", "custom_cumulonimbus"};
    private static final String[] THUNDER_HIGH_CLOUDS = new String[]{"severe_cumulonimbus", "dense_tsegrus", "dark_wall"};
    private static final String[] SEVERITY_7_CLOUDS = new String[]{"cumulonimbus", "severe_cumulonimbus", "tsegrus", "dense_tsegrus", "dark_wall", "custom_cumulonimbus"};
    private static final String[] SEVERITY_6_CLOUDS = new String[]{"nimbostratus", "severe_nimbostratus"};
    private static final String[] SEVERITY_5_CLOUDS = new String[]{"stratocumulus", "dense_stratocumulus", "smaller_stratocumulus", "thicker_stratocumulus", "dithering", "islands", "pathway", "spots", "spotted", "stripe", "stripe_side"};
    private static final String[] SEVERITY_4_CLOUDS = new String[]{"stratus", "heavy_stratus", "overcast", "stronger_stratus", "floating_farlands", "mammatus_thin", "matrix", "pattern", "snow", "cookie", "balls"};
    private static final String[] SEVERITY_3_CLOUDS = new String[]{"cumulus", "dense_cumulus", "cumulus_noise", "tall_noise", "tall_weirdness"};
    private static final String[] SEVERITY_2_CLOUDS = new String[]{"small_cumulus", "itty_bitty_bigger"};
    private static final String[] SEVERITY_1_CLOUDS = new String[]{"itty_bitty", "dense_itty_bitty", "real_itty_bitty"};

    private static String getRandomFrom(String[] clouds) {
        return clouds[RANDOM.nextInt(clouds.length)];
    }

    public static String getCloudIdFromSeverity(int severity) {
        return switch (severity) {
            case 7 -> CloudLibrary.getRandomFrom(SEVERITY_7_CLOUDS);
            case 6 -> CloudLibrary.getRandomFrom(SEVERITY_6_CLOUDS);
            case 5 -> CloudLibrary.getRandomFrom(SEVERITY_5_CLOUDS);
            case 4 -> CloudLibrary.getRandomFrom(SEVERITY_4_CLOUDS);
            case 3 -> CloudLibrary.getRandomFrom(SEVERITY_3_CLOUDS);
            case 2 -> CloudLibrary.getRandomFrom(SEVERITY_2_CLOUDS);
            default -> CloudLibrary.getRandomFrom(SEVERITY_1_CLOUDS);
        };
    }

    public static String getSnowstormCloudId() {
        return CloudLibrary.getRandomFrom(SNOWSTORM_CLOUDS);
    }

    public static String getRandomThunderCloud(int intensity) {
        return intensity == 2 ? CloudLibrary.getRandomFrom(THUNDER_HIGH_CLOUDS) : CloudLibrary.getRandomFrom(THUNDER_LOW_CLOUDS);
    }

    public static String getRandomRainCloud(int intensity, boolean includeThunder) {
        if (includeThunder && RANDOM.nextInt(3) == 0) {
            return CloudLibrary.getRandomThunderCloud(intensity);
        }
        int severity = intensity == 2 ? 6 : 5;
        return CloudLibrary.getCloudIdFromSeverity(severity);
    }

    public static boolean isThunderCloud(String id) {
        return THUNDER_CLOUDS.contains(id);
    }

    public static boolean isSnowCloud(String id) {
        return SNOW_CLOUDS.contains(id);
    }

    public static int getSeverityFromCloudId(String id) {
        return switch (id) {
            case "cumulonimbus", "severe_cumulonimbus", "tsegrus", "dense_tsegrus", "dark_wall", "custom_cumulonimbus" -> 7;
            case "nimbostratus", "severe_nimbostratus" -> 6;
            case "stratocumulus", "dense_stratocumulus", "smaller_stratocumulus", "thicker_stratocumulus", "dithering", "islands", "pathway", "spots", "spotted", "stripe", "stripe_side" -> 5;
            case "stratus", "heavy_stratus", "overcast", "stronger_stratus", "floating_farlands", "mammatus_thin", "matrix", "pattern", "snow", "cookie", "balls" -> 4;
            case "cumulus", "dense_cumulus", "cumulus_noise", "tall_noise", "tall_weirdness" -> 3;
            case "small_cumulus", "itty_bitty_bigger" -> 2;
            case "itty_bitty", "dense_itty_bitty", "real_itty_bitty" -> 1;
            default -> 1;
        };
    }

    public static int getSeverityFromRessourceLocation(ResourceLocation id) {
        return CloudLibrary.getSeverityFromCloudId(id.m_135815_());
    }
}

