/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.DelayedTaskScheduler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TornadoCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder baseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnTornado").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return 0;
            }
            BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(player.m_20183_(), (Level)level), player.m_20183_());
            WindVectorApi.WindSample sample = WindVectorApi.getOrFallback(key);
            WindVector wind = WindVector.fromBase(sample.speedMps(), (float)Math.toRadians(sample.directionDeg()));
            Vec3 playerPos = player.m_20182_();
            if (CloudManager.get((Level)level).getClouds().stream().noneMatch(cloudRegion -> cloudRegion.intersects(new SpawnRegion(player.m_146903_(), player.m_146907_(), 10)) && cloudRegion.getCloudTypeId().toString().equals("simpleclouds:cumulonimbus"))) {
                SimpleCloudsCompat.spawnCloudInBiome("cumulonimbus", key, level, null, wind);
                DelayedTaskScheduler.schedule(500, () -> TornadoManager.spawnServer(level, new Vec3(playerPos.f_82479_, (double)level.m_5736_(), playerPos.f_82481_), 10.0f, wind));
            } else {
                TornadoManager.spawnServer(level, new Vec3(playerPos.f_82479_, (double)level.m_5736_(), playerPos.f_82481_), 10.0f, wind);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado + \u2601\ufe0f Cumulonimbus spawned. in 500 ticks"), true);
            return 1;
        });
        event.getDispatcher().register(baseCommand);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawntornadoes").requires(source -> source.m_6761_(2))).executes(baseCommand.getCommand()));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleartornadoes").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
            TornadoManager.clearTornadoes();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f All tornadoes cleared."), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"removetornado").requires(source -> source.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerLevel level = player.m_284548_();
            if (!level.m_46472_().equals((Object)Level.f_46428_)) {
                return 0;
            }
            Vec3 playerPos = player.m_20182_();
            TornadoInstance tornado = TornadoManager.getActiveTornadoes().stream().filter(t -> t.position.m_82557_(playerPos) < 100.0).findFirst().orElse(null);
            if (tornado != null) {
                TornadoManager.removeTornado(tornado);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83c\udf2a\ufe0f Tornado removed."), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No tornado found near you."));
            }
            return 1;
        }));
    }
}

