/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.wind;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.AtmosphericPhysics;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class WindGenerator {
    private static final Map<BiomeInstanceKey, Set<BiomeInstanceKey>> neighborCache = new ConcurrentHashMap<BiomeInstanceKey, Set<BiomeInstanceKey>>();
    private static final int MIN_DISTANCE = 200;
    private static final float SPEED_SCALING = 1.0f;

    private static Set<BiomeInstanceKey> getNeighbors(BiomeInstanceKey self, Set<BiomeInstanceKey> all) {
        return neighborCache.computeIfAbsent(self, key -> {
            HashSet<BiomeInstanceKey> list = new HashSet<BiomeInstanceKey>();
            BlockPos c = key.samplePos();
            for (BiomeInstanceKey other : all) {
                BlockPos o;
                if (other == key || !(c.m_123331_((Vec3i)(o = other.samplePos())) <= 40000.0)) continue;
                list.add(other);
            }
            return list;
        });
    }

    public static WindVector[] generateWindWeek(BiomeInstanceKey selfKey) {
        BlockPos center = selfKey.samplePos();
        ResourceLocation biome = selfKey.biomeType();
        WindVector[] result = new WindVector[7];
        BiomeForecast biomeForecast = ForecastGenerator.getClosestValidForecast(selfKey, ForecastType.PRESSURE);
        float[][] selfPressure = biomeForecast.getPressure();
        float[][] selfTemp = biomeForecast.getTemperature();
        float[][] selfHumidity = biomeForecast.getHumidity();
        Set<BiomeInstanceKey> neighbors = WindGenerator.getNeighbors(selfKey, ForecastGenerator.getBiomeSamples());
        float altitude = center.m_123342_();
        float biomeFactor = WindGenerator.getBiomeWindModifier(biome);
        double[] airDensity = AtmosphericPhysics.computeAirDensity(selfTemp, selfHumidity);
        for (int d = 0; d < 7; ++d) {
            float Pself = (selfPressure[d][0] + selfPressure[d][1]) * 0.5f;
            float Pavg = 0.0f;
            int count = 0;
            Vec2 windVector = new Vec2(0.0f, 0.0f);
            for (BiomeInstanceKey key : neighbors) {
                double dz;
                float[][] p;
                BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.PRESSURE);
                if (forecast == null || (p = forecast.getPressure()) == null) continue;
                float Pn = (p[d][0] + p[d][1]) * 0.5f;
                Pavg += Pn;
                ++count;
                BlockPos neighborPos = key.samplePos();
                double dx = neighborPos.m_123341_() - center.m_123341_();
                double dist = Math.sqrt(dx * dx + (dz = (double)(neighborPos.m_123343_() - center.m_123343_())) * dz);
                if (dist < 0.01) continue;
                float dP = Pself - Pn;
                float vx = (float)((double)dP * dx / dist);
                float vz = (float)((double)dP * dz / dist);
                windVector = new Vec2(windVector.f_82470_ + vx, windVector.f_82471_ + vz);
            }
            if (count == 0) {
                float randomAngle = (float)(Math.random() * Math.PI * 2.0);
                result[d] = WindVector.fromBase(1.2f, randomAngle);
                continue;
            }
            float dP = Math.abs((Pavg /= (float)count) - Pself);
            float densityFactor = (float)(airDensity[d] / (double)1.225f);
            float normalizedAltitude = Math.min(altitude / 256.0f, 1.0f);
            float altitudeFactor = 0.5f + 0.5f * normalizedAltitude;
            float speed = (float)Math.sqrt(2.0f * dP / densityFactor) * biomeFactor * altitudeFactor * 1.0f;
            speed = Mth.m_14036_((float)speed, (float)1.2f, (float)60.0f);
            int hash = selfKey.hashCode();
            float baseSpeed = speed;
            float gustFactor = Mth.m_14031_((float)((float)(d + hash % 50) * 0.6f)) * 0.5f + 1.6f;
            float gustSpeed = baseSpeed * gustFactor;
            gustSpeed = Mth.m_14036_((float)gustSpeed, (float)1.5f, (float)75.0f);
            if ((double)windVector.m_165907_() > 0.001) {
                windVector = windVector.m_165902_();
            }
            float angle = (float)Math.atan2(windVector.f_82471_, windVector.f_82470_);
            result[d] = new WindVector(baseSpeed, angle, gustSpeed);
        }
        return result;
    }

    private static float getBiomeWindModifier(ResourceLocation biome) {
        String path = biome.m_135815_();
        if (path.contains("forest") || path.contains("taiga") || path.contains("jungle")) {
            return 0.7f;
        }
        if (path.contains("plains") || path.contains("savanna")) {
            return 1.1f;
        }
        if (path.contains("ocean") || path.contains("beach")) {
            return 1.25f;
        }
        if (path.contains("mountain") || path.contains("peak") || path.contains("windswept")) {
            return 1.4f;
        }
        return 1.0f;
    }
}

