/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.particles;

import java.lang.ref.WeakReference;
import net.Gabou.projectatmosphere.modules.tornado.TornadoInstance;
import net.Gabou.projectatmosphere.particles.DebrisParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class DebrisParticle
extends TextureSheetParticle {
    private final WeakReference<TornadoInstance> tornadoRef;
    private final double radius;
    private final double baseY;
    private final float angularSpeed;
    private final float startAngle;

    protected DebrisParticle(ClientLevel level, TornadoInstance tornado, double radius, double height, float angularSpeed) {
        super(level, tornado.position.f_82479_, tornado.position.f_82480_ + height, tornado.position.f_82481_, 0.0, 0.0, 0.0);
        this.tornadoRef = new WeakReference<TornadoInstance>(tornado);
        this.radius = radius;
        this.baseY = height;
        this.angularSpeed = angularSpeed;
        this.startAngle = level.f_46441_.m_188501_() * 360.0f;
        this.f_107225_ = 40 + this.f_107223_.m_188503_(20);
        this.f_107226_ = 0.0f;
        this.f_172258_ = 0.95f;
        this.m_107250_(0.2f, 0.2f);
    }

    public void m_5989_() {
        TornadoInstance tornado = (TornadoInstance)this.tornadoRef.get();
        if (tornado == null) {
            this.m_107274_();
            return;
        }
        float angle = this.startAngle + (tornado.getLifetimeSeconds() * 20.0f + (float)this.f_107224_) * this.angularSpeed;
        double rad = Math.toRadians(angle);
        this.m_107264_(tornado.position.f_82479_ + Math.cos(rad) * this.radius, tornado.position.f_82480_ + this.baseY, tornado.position.f_82481_ + Math.sin(rad) * this.radius);
        this.f_107216_ += 0.02;
        super.m_5989_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<DebrisParticleData> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(DebrisParticleData data, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            DebrisParticle particle = new DebrisParticle(level, data.tornado(), data.radius(), data.height(), data.angularSpeed());
            try {
                particle.m_108335_(this.sprites);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return particle;
        }
    }
}

