/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere;

import dev.nonamecrackers2.simpleclouds.api.SimpleCloudsAPI;
import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.Map;
import java.util.Objects;
import net.Gabou.projectatmosphere.ClientSystemProfile;
import net.Gabou.projectatmosphere.ServerSystemProfile;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.event.BiomeChangeManager;
import net.Gabou.projectatmosphere.event.EventHandler;
import net.Gabou.projectatmosphere.event.SeasonTracker;
import net.Gabou.projectatmosphere.event.TemperatureTickHandler;
import net.Gabou.projectatmosphere.manager.AtmosphereManager;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.temperature.config.BiomeTempUserConfig;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.network.NetworkHandler;
import net.Gabou.projectatmosphere.registry.ClientOnlyRegistrar;
import net.Gabou.projectatmosphere.registry.ModBlocks;
import net.Gabou.projectatmosphere.registry.ModItems;
import net.Gabou.projectatmosphere.registry.ModParticles;
import net.Gabou.projectatmosphere.registry.ModSounds;
import net.Gabou.projectatmosphere.registry.ModTabs;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.TickCounter;
import net.minecraft.locale.Language;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectatmosphere")
@Mod.EventBusSubscriber(modid="projectatmosphere")
public class ProjectAtmosphere {
    public static final float DEFAULT_REGION_RADIUS = 700.0f;
    public static final int DEFAULT_RADIUS = 10000;
    public static long seed;
    public static final String MODID = "projectatmosphere";
    public static final Logger LOGGER;

    public ProjectAtmosphere(FMLJavaModLoadingContext context) {
        LOGGER.info("Project Atmosphere is loading!");
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmoCommonConfig.COMMON_SPEC);
        CompatHandler.init();
        ModItems.register(modEventBus);
        ModSounds.register(modEventBus);
        NetworkHandler.init();
        SimpleCloudsConstants.SPAWN_RADIUS = Math.round(114.28571f * (float)ForecastGenerator.MAX_POSITIONS_PER_BIOME);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(event -> this.clientSetup((FMLClientSetupEvent)event, context));
        MinecraftForge.EVENT_BUS.register(TemperatureTickHandler.class);
        MinecraftForge.EVENT_BUS.register(SeasonTracker.class);
        MinecraftForge.EVENT_BUS.register(BiomeChangeManager.class);
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        MinecraftForge.EVENT_BUS.addListener(TickCounter::onServerTick);
        ModParticles.register(modEventBus);
        ModTabs.REGISTRY.register(modEventBus);
        ModBlocks.REGISTRY.register(modEventBus);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerLevel world = event.getServer().m_129880_(ServerLevel.f_46428_);
        if (world != null) {
            if (!world.f_46443_) {
                AsyncAtmosphereService.init(false);
                SimpleCloudsCompat.init(world);
                seed = world.m_7328_();
            } else {
                AsyncAtmosphereService.init(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.m_129783_();
        AtmosphereManager.onServerStarting(overworld);
        LOGGER.info("BiomeSampler initialized with live biome source.");
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        ServerLevel world;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (world = Objects.requireNonNull((player = (ServerPlayer)player2).m_20194_()).m_129880_(ServerLevel.f_46428_)) != null) {
            AtmosphereManager.onPlayerLogout(world, player);
        }
    }

    private void initModules() {
        ProjectAtmosphere.isSereneLoaded();
        ProjectAtmosphere.sendInfo();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        AsyncAtmosphereService.shutdown();
        ServerLevel world = event.getServer().m_129880_(ServerLevel.f_46428_);
        if (world != null) {
            AtmosphereManager.onServerStopping(world);
            seed = 0L;
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setting up Project Atmosphere (Common)");
        this.initModules();
        TornadoProbabilityManager.init();
        event.enqueueWork(() -> {
            SimpleCloudsAPI.getApi().getHooks().setExternalWeatherControl(true);
            BiomeTempUserConfig.load();
        });
    }

    private void clientSetup(FMLClientSetupEvent event, FMLJavaModLoadingContext context) {
        event.enqueueWork(() -> {
            LOGGER.info("Setting up Project Atmosphere (Client)");
            ClientOnlyRegistrar.registerClient(MinecraftForge.EVENT_BUS, context);
            Map translations = Language.m_128107_().getLanguageData();
            translations.put("sandstorm.debug.blocked", "Nothing to report. Stay alert.");
        });
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        AtmosphereManager.onRegisterCommands(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        LOGGER.info("Player logged in!");
        AtmosphereManager.onPlayerLogin(player2.m_20194_().m_129880_(ServerLevel.f_46428_), player2);
    }

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent event) {
    }

    private static void sendInfo() {
        LOGGER.info("All modules subsystems have been initialized (Serene Seasons detected).");
    }

    private static void isSereneLoaded() {
        if (!ModList.get().isLoaded("sereneseasons")) {
            LOGGER.info("Serene Seasons is not found\u2014skipping all modules subsystems.");
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }

    public static abstract class SystemProfile {
        public final int cpuCount = Runtime.getRuntime().availableProcessors();
        public final long maxMemoryMB = Runtime.getRuntime().maxMemory() / 0x100000L;

        public boolean isLowSpecCPU() {
            return this.cpuCount <= 4;
        }

        public boolean isLowMemory() {
            return this.maxMemoryMB <= 2048L;
        }

        public boolean isLowSpec() {
            return this.isLowSpecCPU() || this.isLowMemory() || !this.isGoodEnoughGPU();
        }

        public abstract boolean isGoodEnoughGPU();

        public abstract String getGPUName();

        public static SystemProfile create(boolean isClient) {
            return isClient ? new ClientSystemProfile() : new ServerSystemProfile();
        }
    }
}

