/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.blocks.SandLayerBlock;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.registry.ModBlocks;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.DelayedTaskScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class BlockManager {
    private static final String WEATHER_DROP_TAG = "PA_WEATHER_DROP";
    private static final int GLOBAL_WEATHER_ITEM_BUDGET_PER_TICK = 64;
    private static int globalWeatherItemTokens = 64;

    public static void resetGlobalWeatherItemBudget() {
        globalWeatherItemTokens = 64;
    }

    private static boolean tryConsumeWeatherItemTokens(int n) {
        if (globalWeatherItemTokens >= n) {
            globalWeatherItemTokens -= n;
            return true;
        }
        return false;
    }

    public static void spawnDust(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.m_213780_();
        WindVector windVector = ForecastOrchestrator.getCurrentWind(AtmosphereUtils.getBiomeKey(level, centerPos), level.m_46467_());
        float windStrength = windVector.baseSpeed();
        int maxSpawn = Math.min(10, (int)(windStrength * 8.0f));
        for (int i = 0; i < maxSpawn; ++i) {
            boolean validGround;
            if (random.m_188501_() > windStrength) continue;
            double angle = (double)windVector.angleRadians() + (random.m_188500_() - 0.5);
            double distance = 10.0 + random.m_188500_() * 10.0;
            int dx = (int)(Math.cos(angle) * distance);
            int dz = (int)(Math.sin(angle) * distance);
            int x = centerPos.m_123341_() + dx;
            int z = centerPos.m_123343_() + dz;
            int y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).m_123342_();
            BlockPos dustPos = new BlockPos(x, y, z);
            BlockState state = level.m_8055_(dustPos);
            BlockState groundState = level.m_8055_(dustPos.m_7495_());
            boolean bl = validGround = groundState.m_60713_(Blocks.f_50493_) || groundState.m_60713_(Blocks.f_49992_) || groundState.m_60713_(Blocks.f_49994_);
            if (!validGround || !state.m_60795_() && !state.m_60713_(Blocks.f_50125_) || BlockPos.m_121990_((BlockPos)dustPos.m_7918_(-4, -1, -4), (BlockPos)dustPos.m_7918_(4, 1, 4)).filter(pos -> level.m_8055_(pos).m_60713_((Block)ModBlocks.DUST.get())).count() >= 6L) continue;
            level.m_46597_(dustPos, ((Block)ModBlocks.DUST.get()).m_49966_());
        }
    }

    public static void spawnSand(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.m_213780_();
        WindVector windVector = ForecastOrchestrator.getCurrentWind(AtmosphereUtils.getBiomeKey(level, centerPos), level.m_46467_());
        float windStrength = windVector.baseSpeed();
        int maxSpawn = Math.min(10, (int)(windStrength * 8.0f));
        for (int i = 0; i < maxSpawn; ++i) {
            boolean validGround;
            if (random.m_188501_() > windStrength) continue;
            double angle = (double)windVector.angleRadians() + (random.m_188500_() - 0.5);
            double distance = 10.0 + random.m_188500_() * 10.0;
            int dx = (int)(Math.cos(angle) * distance);
            int dz = (int)(Math.sin(angle) * distance);
            int x = centerPos.m_123341_() + dx;
            int z = centerPos.m_123343_() + dz;
            int y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).m_123342_();
            BlockPos sandPos = new BlockPos(x, y, z);
            BlockState state = level.m_8055_(sandPos);
            BlockState groundState = level.m_8055_(sandPos.m_7495_());
            boolean bl = validGround = groundState.m_60713_(Blocks.f_50493_) || groundState.m_60713_(Blocks.f_49992_) || groundState.m_60713_(Blocks.f_49994_);
            if (!validGround) continue;
            if (state.m_60795_() || state.m_60713_(Blocks.f_50125_)) {
                level.m_46597_(sandPos, ((Block)ModBlocks.SAND_LAYER.get()).m_49966_());
                continue;
            }
            if (!state.m_60713_((Block)ModBlocks.SAND_LAYER.get())) continue;
            int layers = (Integer)state.m_61143_((Property)SandLayerBlock.LAYERS);
            if (layers < 8) {
                level.m_46597_(sandPos, (BlockState)state.m_61124_((Property)SandLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1)));
                continue;
            }
            level.m_46597_(sandPos, Blocks.f_49992_.m_49966_());
        }
    }

    public static void clearDust(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.m_213780_();
        int radius = 20;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos dustPos = centerPos.m_7918_(dx, 0, dz);
                if (!level.m_8055_(dustPos).m_60713_(Blocks.f_49992_)) continue;
                level.m_46597_(dustPos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public static void spawnCochonnerie(ServerLevel level, BlockPos centerPos) {
        int ENTITY_THRESHOLD = (Integer)AtmoCommonConfig.MAX_STORM_DEBRIS_PER_CHUNK.get();
        ChunkPos chunkPos = new ChunkPos(centerPos);
        AABB chunkBox = new AABB((double)chunkPos.m_45604_(), (double)level.m_141937_(), (double)chunkPos.m_45605_(), (double)(chunkPos.m_45608_() + 1), (double)level.m_151558_(), (double)(chunkPos.m_45609_() + 1));
        long itemCount = level.m_45976_(ItemEntity.class, chunkBox).size();
        if (itemCount >= (long)ENTITY_THRESHOLD) {
            ProjectAtmosphere.LOGGER.debug("[Atmosphere] Skipping debris spawn \u2014 too many items in chunk at {}", (Object)chunkPos);
            return;
        }
        RandomSource random = level.m_213780_();
        int debrisCount = 3 + random.m_188503_(5);
        int allowedSpawn = Math.max(0, ENTITY_THRESHOLD - (int)itemCount);
        if (allowedSpawn <= 0) {
            return;
        }
        int toSpawn = debrisCount = Math.min(debrisCount, allowedSpawn);
        if ((toSpawn = Math.min(toSpawn, globalWeatherItemTokens)) <= 0) {
            return;
        }
        for (int i = 0; i < debrisCount && BlockManager.tryConsumeWeatherItemTokens(1); ++i) {
            double dx = (double)centerPos.m_123341_() + random.m_188583_() * 5.0;
            double dy = (double)(centerPos.m_123342_() + 1) + random.m_188500_();
            double dz = (double)centerPos.m_123343_() + random.m_188583_() * 5.0;
            ItemStack debrisItem = switch (random.m_188503_(4)) {
                case 0 -> new ItemStack((ItemLike)Items.f_42398_);
                case 1 -> new ItemStack((ItemLike)Items.f_41896_);
                case 2 -> new ItemStack((ItemLike)Items.f_42583_);
                default -> new ItemStack((ItemLike)Items.f_41866_);
            };
            ItemEntity entity = new ItemEntity((Level)level, dx, dy, dz, debrisItem);
            entity.getPersistentData().m_128379_(WEATHER_DROP_TAG, true);
            entity.m_32010_(40);
            entity.m_20242_(true);
            entity.m_20334_(random.m_188583_() * 0.05, 0.1 + random.m_188500_() * 0.05, random.m_188583_() * 0.05);
            level.m_7967_((Entity)entity);
            DelayedTaskScheduler.schedule(400 + level.f_46441_.m_188503_(100), () -> {
                if (!entity.m_213877_()) {
                    entity.m_146870_();
                }
            });
        }
    }

    public static void simulateTempesta(ServerLevel level, BlockPos center, int radius) {
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Simulating tempest at {} with radius {}", (Object)center, (Object)radius);
        AsyncAtmosphereService.runStorm(() -> {
            RandomSource random = level.m_213780_();
            int step = radius >= 1000 ? 32 : (radius >= 500 ? 16 : 8);
            int dustChance = 10;
            int debrisChance = 20;
            ArrayList<Runnable> mainThreadTasks = new ArrayList<Runnable>();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int dx = -radius; dx <= radius; dx += step) {
                for (int dz = -radius; dz <= radius; dz += step) {
                    int x = center.m_123341_() + dx;
                    int z = center.m_123343_() + dz;
                    BlockPos posXZ = new BlockPos(x, 0, z);
                    AtomicInteger dustSpawned = new AtomicInteger(0);
                    AtomicInteger debrisSpawned = new AtomicInteger(0);
                    mainThreadTasks.add(() -> {
                        int y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, posXZ).m_123342_();
                        mutablePos.m_122178_(x, y, z);
                        if (debrisSpawned.get() < 30 && random.m_188503_(debrisChance) == 0) {
                            BlockManager.spawnCochonnerie(level, mutablePos.m_7949_());
                            debrisSpawned.incrementAndGet();
                            DelayedTaskScheduler.schedule(6000, () -> debrisSpawned.updateAndGet(v -> Math.max(0, v - 1)));
                        }
                        if (dustSpawned.get() < 8 && random.m_188503_(dustChance) == 0) {
                            BlockManager.spawnDust(level, mutablePos.m_7949_());
                            dustSpawned.incrementAndGet();
                            DelayedTaskScheduler.schedule(2000, () -> dustSpawned.updateAndGet(v -> Math.max(0, v - 1)));
                        }
                    });
                }
            }
            int batchSize = 100;
            for (int i = 0; i < mainThreadTasks.size(); i += batchSize) {
                int start = i;
                int end = Math.min(i + batchSize, mainThreadTasks.size());
                List batch = mainThreadTasks.subList(start, end);
                level.m_7654_().execute(() -> {
                    for (Runnable task : batch) {
                        task.run();
                    }
                });
            }
            BlockManager.resetGlobalWeatherItemBudget();
        });
    }
}

