/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.compat;

import net.Gabou.projectatmosphere.compat.TemperatureMod;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompatHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"projectatmosphere");

    private CompatHandler() {
    }

    public static TemperatureMod getActiveTemperatureMod() {
        if (ModList.get().isLoaded("toughasnails")) {
            return TemperatureMod.TOUGH_AS_NAILS;
        }
        if (ModList.get().isLoaded("coldsweat")) {
            return TemperatureMod.COLD_SWEAT;
        }
        return TemperatureMod.NONE;
    }

    public static boolean isSandStormsLoaded() {
        return ModList.get().isLoaded("sandstorm");
    }

    public static boolean isToughAsNailsLoaded() {
        return CompatHandler.getActiveTemperatureMod() == TemperatureMod.TOUGH_AS_NAILS;
    }

    public static boolean isColdSweatLoaded() {
        return CompatHandler.getActiveTemperatureMod() == TemperatureMod.COLD_SWEAT;
    }

    public static boolean isATemperatureModLoaded() {
        return CompatHandler.getActiveTemperatureMod() != TemperatureMod.NONE;
    }

    public static void init() {
        TemperatureMod mod = CompatHandler.getActiveTemperatureMod();
        switch (mod) {
            case TOUGH_AS_NAILS: {
                LOGGER.info("Tough As Nails loaded");
                break;
            }
            case COLD_SWEAT: {
                LOGGER.info("Cold Sweat loaded");
                break;
            }
            case NONE: {
                LOGGER.info("No temperature mod loaded, skipping compatibility setup.");
            }
        }
        String sandStormMsg = CompatHandler.isSandStormsLoaded() ? "Sand Storms mod loaded, enabling compatibility." : "Sand Storms mod not found.";
        LOGGER.info(sandStormMsg);
    }
}

