/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BiomeClientTemperatureCache {
    private static final Map<ResourceLocation, float[]> DAILY_FORECASTS = new ConcurrentHashMap<ResourceLocation, float[]>();

    public static void updateDayForecasts(Map<ResourceLocation, float[]> newData) {
        DAILY_FORECASTS.clear();
        DAILY_FORECASTS.putAll(newData);
    }

    public static float getTemperature(ResourceLocation biome, Level level) {
        float[] arr = DAILY_FORECASTS.get(biome);
        if (arr == null || arr.length == 0) {
            return 0.5f;
        }
        long timeOfDay = level.m_46468_() % 24000L;
        int i = (int)((float)timeOfDay / 24000.0f * (float)arr.length);
        i = Math.max(0, Math.min(i, arr.length - 1));
        return arr[i];
    }

    public static boolean isFreezing(ResourceLocation biome, Level level) {
        return BiomeClientTemperatureCache.getTemperature(biome, level) < 0.15f;
    }

    public static void clear() {
        DAILY_FORECASTS.clear();
    }
}

