/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import dev.nonamecrackers2.simpleclouds.api.common.cloud.spawning.SpawnInfo;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudGenerator;
import dev.nonamecrackers2.simpleclouds.common.cloud.spawning.CloudSpawningConfig;
import dev.nonamecrackers2.simpleclouds.common.world.SpawnRegion;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.PoolType;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.CloudLibrary;
import net.Gabou.projectatmosphere.modules.storm.GlobalStormHistoryData;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.WeatherSampler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.world.level.Level;
import org.joml.Vector2i;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class SimpleCloudSpawner {
    private static final int SPAWN_INTERVAL_TICKS = 24000;
    private static long LAST_SPAWN_TICK = 0L;
    private static float PRESSION_MOYENNE = 1013.25f;
    private static int NB_MAX_CLOUDS_TYPES = 4;
    private static int currentViolence = 0;
    private static float DEW_GAP_MODIFIER = 1.0f;
    private static float PRESSURE_MODIFIER = 1.0f;
    private static float HUMIDITY_MODIFIER = 1.0f;
    private static float TEMPERATURE_MODIFIER = 1.0f;
    private static final float STORM_BIAS = 1.5f;
    private static final float SUNNY_THRESHOLD = 0.45f;

    public static int getCurrentViolence() {
        return currentViolence;
    }

    private static int setViolence(int violence) {
        if (violence < 0 || violence > 7) {
            throw new IllegalArgumentException("Violence must be between 0 and 7");
        }
        return violence;
    }

    public static void trySpawnClouds(ServerLevel level, CloudGenerator generator) {
        List spawnRegions = generator.getSpawnRegions();
        if (spawnRegions.isEmpty()) {
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] No spawn regions available");
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        CloudSpawningConfig config = (CloudSpawningConfig)generator.getSpawnConfig().get();
        int currentCount = generator.getClouds().size();
        int maxRegions = config.getMaxInitialRegions();
        int remaining = maxRegions - currentCount;
        if (remaining <= 0) {
            return;
        }
        int toSpawn = Mth.m_14045_((int)BiasedToBottomInt.m_146367_((int)1, (int)5).m_214085_(random), (int)1, (int)remaining);
        for (int i = 0; i < toSpawn; ++i) {
            SpawnRegion region = (SpawnRegion)spawnRegions.get(random.m_188503_(spawnRegions.size()));
            int radius = BiasedToBottomInt.m_146367_((int)SimpleCloudsCompat.MIN_RADIUS, (int)SimpleCloudsCompat.MAX_RADIUS).m_214085_(random);
            Vector2i point = SpawnRegion.getRandomPointInRegion((SpawnRegion)region, (RandomSource)random);
            AsyncAtmosphereService.runWithCallback(PoolType.WEATHER, () -> {
                String cloudId;
                boolean snowstorm;
                Set<BiomeInstanceKey> sample = WeatherSampler.sampleBiomesInArea(point.x, point.y, radius, level);
                WeatherSampler.WeatherStats stats = WeatherSampler.computeWeatherStats(sample, level, level.m_46467_());
                if (stats == null) {
                    return null;
                }
                boolean isWinter = SeasonHelper.getSeasonState((Level)level).getSeason() == Season.WINTER;
                boolean freezing = stats.temperature() <= 0.0f;
                int severity = SimpleCloudSpawner.determineCloudSeverity(stats.temperature(), stats.humidity(), stats.pressure(), SimpleCloudSpawner.calculateDewPoint(stats.temperature(), stats.humidity()), stats.stormChance(), level);
                if (severity <= 0) {
                    return null;
                }
                boolean bl = snowstorm = severity > 5 && freezing;
                if (snowstorm) {
                    cloudId = CloudLibrary.getSnowstormCloudId();
                } else {
                    cloudId = CloudLibrary.getCloudIdFromSeverity(severity);
                    if (CloudLibrary.isThunderCloud(cloudId) && (isWinter || freezing)) {
                        cloudId = CloudLibrary.getCloudIdFromSeverity(5);
                    }
                }
                return new CloudSpawnRequest(stats, radius, cloudId);
            }, request -> {
                if (request == null) {
                    return;
                }
                ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"simpleclouds", (String)request.cloudId());
                CloudSpawningConfig.Info info = config.getWeightInfo(rl);
                if (info == null) {
                    ProjectAtmosphere.LOGGER.warn("[Atmosphere] Unknown cloud type: {}", (Object)request.cloudId());
                    return;
                }
                BiomeInstanceKey biomeKey = new BiomeInstanceKey(request.stats().dominantBiome(), request.stats().pos());
                Optional<CloudRegion> dummyOpt = SimpleCloudsCompat.createRegion((SpawnInfo)info, biomeKey, level, random, request.stats().windVector(), generator);
                if (dummyOpt.isEmpty()) {
                    return;
                }
                CloudRegion dummy = dummyOpt.get();
                dummy.setRadius((float)request.radius());
                SimpleCloudsCompat.spawnCloudInBiome(request.cloudId(), biomeKey, level, dummy, request.stats().windVector());
            });
        }
    }

    public static BlockPos getRandomPosInRegion(SpawnRegion region, RandomSource random, ServerLevel level) {
        Vector2i vec = SpawnRegion.getRandomPointInRegion((SpawnRegion)region, (RandomSource)random);
        return new BlockPos(vec.x, level.m_5736_(), vec.y);
    }

    public static float calculateDewPoint(float temperature, float humidity) {
        float ACONST = 17.62f;
        float BCONST = 243.12f;
        float result = 17.62f * temperature / (243.12f + temperature) + (float)Math.log(humidity / 100.0f);
        return 243.12f * result / (17.62f - result);
    }

    public static int determineCloudSeverity(float temperature, float humidity, float pressure, float dewPoint, float stormChance, ServerLevel level) {
        float dewGap = Math.max(0.0f, temperature - dewPoint);
        float dewGapFactor = 1.0f - Math.min(dewGap / 12.0f, 1.0f);
        float pressureFactor = (PRESSION_MOYENNE - pressure) / 60.0f;
        pressureFactor = Math.max(-1.0f, Math.min(pressureFactor, 1.0f));
        float humidityFactor = humidity / 100.0f;
        float tempIdealness = 1.0f - Math.abs(temperature - 18.0f) / 45.0f;
        float instability = dewGapFactor * 0.4f + pressureFactor * 0.25f + humidityFactor * 0.55f + tempIdealness * 0.3f;
        instability = Math.min(Math.max(instability, 0.0f), 1.0f);
        int currentDay = (int)(level.m_46468_() / 24000L);
        GlobalStormHistoryData data = GlobalStormHistoryData.get(level);
        int lastStrong = data.getLastSevereDay();
        int daysSince = lastStrong == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.max(0, currentDay - lastStrong);
        int severity = SimpleCloudSpawner.getSeverity(stormChance, daysSince, instability);
        if (severity >= 5) {
            data.recordSevere(currentDay);
        }
        return severity;
    }

    private static int getSeverity(float stormChance, int daysSince, float instability) {
        float boost = 1.0f + 0.07f * (float)daysSince;
        boost = Math.min(boost, 1.7f);
        float adjustedChance = Math.min(1.0f, stormChance * boost * 1.5f);
        float weighted = instability * adjustedChance * 4.5f;
        float raw = (float)(1.0 / (1.0 + Math.exp(-2.3 * ((double)weighted - 1.0))));
        float dayBias = Math.min(1.0f, (float)daysSince / 10.0f);
        float biasAdjusted = raw + 0.25f * dayBias * (1.0f - raw);
        int severity = (int)Math.floor(biasAdjusted * 6.0f) + 1;
        severity = Math.max(1, Math.min(7, severity));
        return severity;
    }

    public static void spawnCloudForPlayer(ServerPlayer player, ServerLevel level) {
        BiomeInstanceKey key = new BiomeInstanceKey(AtmosphereUtils.getBiomeLocation(player.m_20183_(), (Level)level), player.m_20183_());
        SimpleCloudsCompat.spawnCloudInBiome("itty_bitty", key, level, null, ForecastOrchestrator.getCurrentWind(key, level.m_46467_()));
    }

    record CloudSpawnRequest(WeatherSampler.WeatherStats stats, int radius, String cloudId) {
    }
}

