/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;

public record WindVector(float baseSpeed, float angleRadians, float gustSpeed) {
    private static final Map<BiomeInstanceKey, WindSample> CURRENT = new HashMap<BiomeInstanceKey, WindSample>();

    public WindVector add(WindVector other) {
        return new WindVector(this.baseSpeed + other.baseSpeed, this.angleRadians + other.angleRadians, this.gustSpeed + other.gustSpeed);
    }

    public WindVector subtract(WindVector other) {
        return new WindVector(this.baseSpeed - other.baseSpeed, this.angleRadians - other.angleRadians, this.gustSpeed - other.gustSpeed);
    }

    public WindVector divide(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be greater than zero");
        }
        return new WindVector(this.baseSpeed / (float)count, this.angleRadians / (float)count, this.gustSpeed / (float)count);
    }

    public static WindVector fromBase(float baseSpeed, float angleRadians) {
        return new WindVector(baseSpeed, angleRadians, baseSpeed);
    }

    public static void set(BiomeInstanceKey key, float effectiveSpeed, float directionDeg) {
        CURRENT.put(key, new WindSample(effectiveSpeed, directionDeg));
    }

    public static WindSample getOrFallback(BiomeInstanceKey key) {
        return CURRENT.computeIfAbsent(key, k -> WindVector.randomSample(new Random()));
    }

    private static WindSample randomSample(Random rng) {
        float speed = rng.nextFloat();
        float dir = rng.nextFloat() * 360.0f;
        return new WindSample(speed, dir);
    }

    public record WindSample(float speedMps, float directionDeg) {
    }
}

