/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TodoGUI
extends JFrame {
    private final List<Section> sections = new ArrayList<Section>();
    private static final String SAVE_FILE = "todo_progress.json";

    public TodoGUI() {
        this.setTitle("Project Atmosphere \u2013 Interactive TODO");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        this.add((Component)scrollPane, "Center");
        if (!this.loadFromJson()) {
            this.loadTasks();
        }
        for (Section section : this.sections) {
            JLabel sectionLabel = new JLabel("\ud83d\udccc " + section.title);
            sectionLabel.setFont(new Font("Arial", 1, 16));
            contentPanel.add(sectionLabel);
            for (Task task : section.tasks) {
                JCheckBox box = new JCheckBox(task.description, task.done);
                box.addActionListener(e -> {
                    task.done = box.isSelected();
                });
                contentPanel.add(box);
            }
            contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        JButton saveButton = new JButton("Save Markdown + Progress");
        saveButton.addActionListener(e -> {
            this.saveToMarkdown();
            this.saveToJson();
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(saveButton);
        this.add((Component)bottomPanel, "South");
        this.setSize(600, 700);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void loadTasks() {
        Section clouds = new Section("Cloud System");
        clouds.add("Implement GeckoLib CloudEntity");
        clouds.add("Add cloud variants: cumulus, cirrus, fog");
        clouds.add("Add wind drifting logic");
        clouds.add("Detect and merge cloud entities");
        clouds.add("Save merged state in NBT with original identity");
        clouds.add("Restore original clouds after split");
        this.sections.add(clouds);
        Section fog = new Section("Fog System");
        fog.add("Add morning fog when temperature < 10\u00b0C");
        fog.add("Customize fog by biome: jungle, swamp, plains");
        fog.add("Fade fog after sunrise or player descent");
        fog.add("Use safe Forge hook to override vanilla fog");
        this.sections.add(fog);
        Section shader = new Section("Shader Compatibility");
        shader.add("Do not override sky renderer (retain shader support)");
        shader.add("Add config option: cloudMode FULL | HYBRID | VANILLA");
        shader.add("Ensure visual blend for vanilla + custom clouds");
        shader.add("Test with Complementary, BSL, SEUS, Iris+Sodium");
        this.sections.add(shader);
        Section weather = new Section("Weather Manager");
        weather.add("Create server-authoritative WeatherManager");
        weather.add("Override vanilla rain/thunder states");
        weather.add("Sync weather state to clients");
        weather.add("Simulate 7-day forecast based on season + temperature");
        weather.add("Forecast includes random \u00b110\u00b0C scaling");
        weather.add("Final displayed temp varies \u00b13\u00b0C daily");
        weather.add("Generate storms using season + wind + temperature");
        this.sections.add(weather);
        Section extreme = new Section("Extreme Weather Events");
        extreme.add("Implement TornadoEvent (wind + suction)");
        extreme.add("Implement HurricaneEvent (wide-area wind + rain)");
        extreme.add("Implement SandstormEvent (reduced visibility + particles)");
        extreme.add("Implement SnowstormEvent with snow accumulation");
        extreme.add("Handle spring melt logic for snow_pile blocks");
        this.sections.add(extreme);
        Section temp = new Section("Temperature System");
        temp.add("Integrate Serene Seasons API");
        temp.add("Add fallback temperature simulation if SS missing");
        temp.add("Mixin to override temperature source if needed");
        temp.add("Expose API to other mods for temp reading");
        temp.add("Allow forecast-based temperature overrides");
        this.sections.add(temp);
        Section rain = new Section("Rain & Crops");
        rain.add("Integrate with Farmer\u2019s Delight: rain helps growth");
        rain.add("Track rainfall per chunk");
        rain.add("Convert dirt to corpse dirt if too much rain");
        rain.add("Only affect uncovered farmland");
        this.sections.add(rain);
        Section config = new Section("Config & Performance");
        config.add("Create projectatmosphere.toml config");
        config.add("Options: fog, cloud mode, forecast deviation, event toggle");
        config.add("Use patterns: Observer, Strategy, Factory");
        config.add("Avoid BlockEntities \u2014 use chunk managers");
        config.add("Memoize biome \u2192 weather lookup");
        config.add("Separate ClientWeatherHandler and ServerWeatherHandler");
        this.sections.add(config);
        Section compat = new Section("Mod Compatibility");
        compat.add("Farmer\u2019s Delight");
        compat.add("Naturalist");
        compat.add("Immersive Weathering");
        compat.add("Tough As Nails");
        compat.add("Epic Fight");
        this.sections.add(compat);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromJson() {
        try (FileReader reader = new FileReader(SAVE_FILE);){
            Gson gson = new Gson();
            List loaded = (List)gson.fromJson((Reader)reader, new TypeToken<List<Section>>(){}.getType());
            if (loaded == null) return false;
            this.sections.clear();
            this.sections.addAll(loaded);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void saveToJson() {
        try (FileWriter writer = new FileWriter(SAVE_FILE);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(this.sections, (Appendable)writer);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to save progress: " + e.getMessage());
        }
    }

    private void saveToMarkdown() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save TODO as Markdown");
        chooser.setSelectedFile(new File("ProjectAtmosphereTODO.md"));
        if (chooser.showSaveDialog(this) == 0) {
            try (FileWriter writer = new FileWriter(chooser.getSelectedFile());){
                writer.write("# \ud83c\udf29\ufe0f Project Atmosphere \u2013 TODO Checklist\\n\\n");
                for (Section section : this.sections) {
                    writer.write("## " + section.title + "\\n\\n");
                    for (Task task : section.tasks) {
                        writer.write(String.format("- [%s] %s\\n", task.done ? "x" : " ", task.description));
                    }
                    writer.write("\\n");
                }
                JOptionPane.showMessageDialog(this, "\u2705 Markdown and progress saved!");
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "\u274c Error: " + ex.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(TodoGUI::new);
    }

    static class Section {
        String title;
        List<Task> tasks = new ArrayList<Task>();

        Section(String title) {
            this.title = title;
        }

        void add(String description) {
            this.tasks.add(new Task(description));
        }
    }

    static class Task {
        String description;
        boolean done;

        Task(String description) {
            this.description = description;
            this.done = false;
        }
    }
}

