/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.api;

import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.server.level.ServerLevel;

public final class WindVectorApi {
    private WindVectorApi() {
    }

    public static WindSample getSurface(BiomeInstanceKey key) {
        WindVector.WindSample w = WindVector.getOrFallback(key);
        return new WindSample(w.speedMps(), w.directionDeg());
    }

    public static WindSample getOrFallback(BiomeInstanceKey key) {
        return WindVectorApi.getSurface(key);
    }

    public static WindSample getAloftProxy(BiomeInstanceKey key, ServerLevel level) {
        WindSample surface = WindVectorApi.getSurface(key);
        float dir = surface.directionDeg() + (level.random.nextFloat() * 20.0f - 10.0f);
        float speed = surface.speedMps() + 5.0f;
        return new WindSample(speed, dir);
    }

    public record WindSample(float speedMps, float directionDeg) {
    }
}

