/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.blocks.SandLayerBlock;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.registry.ModBlocks;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.DelayedTaskScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class BlockManager {
    private static final String WEATHER_DROP_TAG = "PA_WEATHER_DROP";
    private static final int GLOBAL_WEATHER_ITEM_BUDGET_PER_TICK = 64;
    private static int globalWeatherItemTokens = 64;

    public static void resetGlobalWeatherItemBudget() {
        globalWeatherItemTokens = 64;
    }

    private static boolean tryConsumeWeatherItemTokens(int n) {
        if (globalWeatherItemTokens >= n) {
            globalWeatherItemTokens -= n;
            return true;
        }
        return false;
    }

    public static void spawnDust(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.getRandom();
        WindVector windVector = ForecastOrchestrator.getCurrentWind(AtmosphereUtils.getBiomeKey(level, centerPos), level.getGameTime());
        float windStrength = windVector.baseSpeed();
        int maxSpawn = Math.min(10, (int)(windStrength * 8.0f));
        for (int i = 0; i < maxSpawn; ++i) {
            boolean validGround;
            if (random.nextFloat() > windStrength) continue;
            double angle = (double)windVector.angleRadians() + (random.nextDouble() - 0.5);
            double distance = 10.0 + random.nextDouble() * 10.0;
            int dx = (int)(Math.cos(angle) * distance);
            int dz = (int)(Math.sin(angle) * distance);
            int x = centerPos.getX() + dx;
            int z = centerPos.getZ() + dz;
            int y = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).getY();
            BlockPos dustPos = new BlockPos(x, y, z);
            BlockState state = level.getBlockState(dustPos);
            BlockState groundState = level.getBlockState(dustPos.below());
            boolean bl = validGround = groundState.is(Blocks.DIRT) || groundState.is(Blocks.SAND) || groundState.is(Blocks.GRAVEL);
            if (!validGround || !state.isAir() && !state.is(Blocks.SNOW) || BlockPos.betweenClosedStream((BlockPos)dustPos.offset(-4, -1, -4), (BlockPos)dustPos.offset(4, 1, 4)).filter(pos -> level.getBlockState(pos).is((Block)ModBlocks.DUST.get())).count() >= 6L) continue;
            level.setBlockAndUpdate(dustPos, ((Block)ModBlocks.DUST.get()).defaultBlockState());
        }
    }

    public static void spawnSand(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.getRandom();
        WindVector windVector = ForecastOrchestrator.getCurrentWind(AtmosphereUtils.getBiomeKey(level, centerPos), level.getGameTime());
        float windStrength = windVector.baseSpeed();
        int maxSpawn = Math.min(10, (int)(windStrength * 8.0f));
        for (int i = 0; i < maxSpawn; ++i) {
            boolean validGround;
            if (random.nextFloat() > windStrength) continue;
            double angle = (double)windVector.angleRadians() + (random.nextDouble() - 0.5);
            double distance = 10.0 + random.nextDouble() * 10.0;
            int dx = (int)(Math.cos(angle) * distance);
            int dz = (int)(Math.sin(angle) * distance);
            int x = centerPos.getX() + dx;
            int z = centerPos.getZ() + dz;
            int y = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z)).getY();
            BlockPos sandPos = new BlockPos(x, y, z);
            BlockState state = level.getBlockState(sandPos);
            BlockState groundState = level.getBlockState(sandPos.below());
            boolean bl = validGround = groundState.is(Blocks.DIRT) || groundState.is(Blocks.SAND) || groundState.is(Blocks.GRAVEL);
            if (!validGround) continue;
            if (state.isAir() || state.is(Blocks.SNOW)) {
                level.setBlockAndUpdate(sandPos, ((Block)ModBlocks.SAND_LAYER.get()).defaultBlockState());
                continue;
            }
            if (!state.is((Block)ModBlocks.SAND_LAYER.get())) continue;
            int layers = (Integer)state.getValue((Property)SandLayerBlock.LAYERS);
            if (layers < 8) {
                level.setBlockAndUpdate(sandPos, (BlockState)state.setValue((Property)SandLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1)));
                continue;
            }
            level.setBlockAndUpdate(sandPos, Blocks.SAND.defaultBlockState());
        }
    }

    public static void clearDust(ServerLevel level, BlockPos centerPos) {
        RandomSource random = level.getRandom();
        int radius = 20;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos dustPos = centerPos.offset(dx, 0, dz);
                if (!level.getBlockState(dustPos).is(Blocks.SAND)) continue;
                level.setBlockAndUpdate(dustPos, Blocks.AIR.defaultBlockState());
            }
        }
    }

    public static void spawnCochonnerie(ServerLevel level, BlockPos centerPos) {
        int ENTITY_THRESHOLD = (Integer)AtmoCommonConfig.MAX_STORM_DEBRIS_PER_CHUNK.get();
        ChunkPos chunkPos = new ChunkPos(centerPos);
        AABB chunkBox = new AABB((double)chunkPos.getMinBlockX(), (double)level.getMinBuildHeight(), (double)chunkPos.getMinBlockZ(), (double)(chunkPos.getMaxBlockX() + 1), (double)level.getMaxBuildHeight(), (double)(chunkPos.getMaxBlockZ() + 1));
        long itemCount = level.getEntitiesOfClass(ItemEntity.class, chunkBox).size();
        if (itemCount >= (long)ENTITY_THRESHOLD) {
            ProjectAtmosphere.LOGGER.debug("[Atmosphere] Skipping debris spawn \u2014 too many items in chunk at {}", (Object)chunkPos);
            return;
        }
        RandomSource random = level.getRandom();
        int debrisCount = 3 + random.nextInt(5);
        int allowedSpawn = Math.max(0, ENTITY_THRESHOLD - (int)itemCount);
        if (allowedSpawn <= 0) {
            return;
        }
        int toSpawn = debrisCount = Math.min(debrisCount, allowedSpawn);
        if ((toSpawn = Math.min(toSpawn, globalWeatherItemTokens)) <= 0) {
            return;
        }
        for (int i = 0; i < debrisCount && BlockManager.tryConsumeWeatherItemTokens(1); ++i) {
            double dx = (double)centerPos.getX() + random.nextGaussian() * 5.0;
            double dy = (double)(centerPos.getY() + 1) + random.nextDouble();
            double dz = (double)centerPos.getZ() + random.nextGaussian() * 5.0;
            ItemStack debrisItem = switch (random.nextInt(4)) {
                case 0 -> new ItemStack((ItemLike)Items.STICK);
                case 1 -> new ItemStack((ItemLike)Items.OAK_LEAVES);
                case 2 -> new ItemStack((ItemLike)Items.ROTTEN_FLESH);
                default -> new ItemStack((ItemLike)Items.DEAD_BUSH);
            };
            ItemEntity entity = new ItemEntity((Level)level, dx, dy, dz, debrisItem);
            entity.getPersistentData().putBoolean(WEATHER_DROP_TAG, true);
            entity.setPickUpDelay(40);
            entity.setNoGravity(true);
            entity.setDeltaMovement(random.nextGaussian() * 0.05, 0.1 + random.nextDouble() * 0.05, random.nextGaussian() * 0.05);
            level.addFreshEntity((Entity)entity);
            DelayedTaskScheduler.schedule(400 + level.random.nextInt(100), () -> {
                if (!entity.isRemoved()) {
                    entity.discard();
                }
            });
        }
    }

    public static void simulateTempesta(ServerLevel level, BlockPos center, int radius) {
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Simulating tempest at {} with radius {}", (Object)center, (Object)radius);
        AsyncAtmosphereService.runStorm(() -> {
            RandomSource random = level.getRandom();
            int step = radius >= 1000 ? 32 : (radius >= 500 ? 16 : 8);
            int dustChance = 10;
            int debrisChance = 20;
            ArrayList<Runnable> mainThreadTasks = new ArrayList<Runnable>();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int dx = -radius; dx <= radius; dx += step) {
                for (int dz = -radius; dz <= radius; dz += step) {
                    int x = center.getX() + dx;
                    int z = center.getZ() + dz;
                    BlockPos posXZ = new BlockPos(x, 0, z);
                    AtomicInteger dustSpawned = new AtomicInteger(0);
                    AtomicInteger debrisSpawned = new AtomicInteger(0);
                    mainThreadTasks.add(() -> {
                        int y = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, posXZ).getY();
                        mutablePos.set(x, y, z);
                        if (debrisSpawned.get() < 30 && random.nextInt(debrisChance) == 0) {
                            BlockManager.spawnCochonnerie(level, mutablePos.immutable());
                            debrisSpawned.incrementAndGet();
                            DelayedTaskScheduler.schedule(6000, () -> debrisSpawned.updateAndGet(v -> Math.max(0, v - 1)));
                        }
                        if (dustSpawned.get() < 8 && random.nextInt(dustChance) == 0) {
                            BlockManager.spawnDust(level, mutablePos.immutable());
                            dustSpawned.incrementAndGet();
                            DelayedTaskScheduler.schedule(2000, () -> dustSpawned.updateAndGet(v -> Math.max(0, v - 1)));
                        }
                    });
                }
            }
            int batchSize = 100;
            for (int i = 0; i < mainThreadTasks.size(); i += batchSize) {
                int start = i;
                int end = Math.min(i + batchSize, mainThreadTasks.size());
                List batch = mainThreadTasks.subList(start, end);
                level.getServer().execute(() -> {
                    for (Runnable task : batch) {
                        task.run();
                    }
                });
            }
            BlockManager.resetGlobalWeatherItemBudget();
        });
    }
}

