/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Gabou.projectatmosphere.manager.ForecastGenerator;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.Gabou.projectatmosphere.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class ForecastDataStorage {
    private static final String FILE_NAME = "forecast_centers.json";
    private static final String FORECAST_FILE = "biome_forecasts.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean hasForecastData;
    private static boolean hasCenterData;
    public static final Map<UUID, BlockPos> playerData;

    public static void saveAll(ServerLevel world) {
        ForecastDataStorage.savePlayerCenters(world);
        ForecastDataStorage.saveForecastMap(world);
    }

    public static void clearAll(ServerLevel world) {
        playerData.clear();
        hasForecastData = false;
        hasCenterData = false;
        try {
            Files.deleteIfExists(ForecastDataStorage.getSavePath(world, FILE_NAME));
            Files.deleteIfExists(ForecastDataStorage.getSavePath(world, FORECAST_FILE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadAll(ServerLevel world) {
        ForecastDataStorage.clearAll(world);
        ForecastDataStorage.loadPlayerCenters(world);
        ForecastDataStorage.loadForecastMap(world);
    }

    public static boolean hasForecastData() {
        return hasForecastData;
    }

    public static boolean hasCenterData() {
        return hasCenterData;
    }

    private static void savePlayerCenters(ServerLevel world) {
        JsonObject root = new JsonObject();
        for (Map.Entry<UUID, BlockPos> entry : playerData.entrySet()) {
            UUID uuid = entry.getKey();
            BlockPos pos = entry.getValue();
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)pos.getX());
            obj.addProperty("y", (Number)pos.getY());
            obj.addProperty("z", (Number)pos.getZ());
            root.add(uuid.toString(), (JsonElement)obj);
        }
        try {
            Path path = ForecastDataStorage.getSavePath(world, FILE_NAME);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void loadPlayerCenters(ServerLevel world) {
        Path path = ForecastDataStorage.getSavePath(world, FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        hasCenterData = Files.exists(StorageUtils.getPerWorldSavePath(world, FILE_NAME), new LinkOption[0]);
        try (BufferedReader r = Files.newBufferedReader(path);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            for (Map.Entry entry : root.entrySet()) {
                UUID uuid = UUID.fromString((String)entry.getKey());
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                int x = obj.get("x").getAsInt();
                int y = obj.get("y").getAsInt();
                int z = obj.get("z").getAsInt();
                playerData.put(uuid, new BlockPos(x, y, z));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void saveForecastMap(ServerLevel world) {
        JsonObject root = new JsonObject();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : ForecastGenerator.getForecastMap().entrySet()) {
            BiomeInstanceKey key = entry.getKey();
            BiomeForecast forecast = entry.getValue();
            JsonObject obj = new JsonObject();
            obj.addProperty("biome", key.biomeType().toString());
            obj.addProperty("x", (Number)key.samplePos().getX());
            obj.addProperty("y", (Number)key.samplePos().getY());
            obj.addProperty("z", (Number)key.samplePos().getZ());
            obj.add("temperature", (JsonElement)ForecastDataStorage.serializeWeek(forecast.getTemperature()));
            obj.add("pressure", (JsonElement)ForecastDataStorage.serializeWeek(forecast.getPressure()));
            obj.add("humidity", (JsonElement)ForecastDataStorage.serializeWeek(forecast.getHumidity()));
            obj.add("wind", (JsonElement)ForecastDataStorage.serializeWinds(forecast.getWind()));
            obj.add("stormChance", (JsonElement)ForecastDataStorage.serializeWeek(forecast.getStormChance()));
            root.add(key.toString(), (JsonElement)obj);
        }
        try {
            Path path = ForecastDataStorage.getSavePath(world, FORECAST_FILE);
            try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void loadForecastMap(ServerLevel world) {
        Path path = ForecastDataStorage.getSavePath(world, FORECAST_FILE);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        hasForecastData = Files.exists(StorageUtils.getPerWorldSavePath(world, FORECAST_FILE), new LinkOption[0]);
        try (BufferedReader r = Files.newBufferedReader(path);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            for (Map.Entry entry : root.entrySet()) {
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                ResourceLocation biome = ResourceLocation.parse((String)obj.get("biome").getAsString());
                BlockPos pos = new BlockPos(obj.get("x").getAsInt(), obj.get("y").getAsInt(), obj.get("z").getAsInt());
                BiomeInstanceKey key = new BiomeInstanceKey(biome, pos);
                BiomeForecast forecast = new BiomeForecast();
                forecast.setTemperature(ForecastDataStorage.deserializeWeek(obj.getAsJsonArray("temperature")));
                forecast.setPressure(ForecastDataStorage.deserializeWeek(obj.getAsJsonArray("pressure")));
                forecast.setHumidity(ForecastDataStorage.deserializeWeek(obj.getAsJsonArray("humidity")));
                forecast.setWind(ForecastDataStorage.deserializeWinds(obj.getAsJsonArray("wind")));
                forecast.setStormChance(ForecastDataStorage.deserializeWeek(obj.getAsJsonArray("stormChance")));
                ForecastGenerator.putForecast(key, forecast);
            }
            ForecastGenerator.groupForecastsByBiome();
            ForecastGenerator.groupBiomeByType();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static Path getSavePath(ServerLevel world, String fileName) {
        return StorageUtils.getPerWorldSavePath(world, fileName);
    }

    private static JsonArray serializeWeek(float[][] week) {
        JsonArray array = new JsonArray();
        if (week == null) {
            return array;
        }
        for (float[] pair : week) {
            JsonArray pairArr = new JsonArray();
            pairArr.add((Number)Float.valueOf(pair[0]));
            pairArr.add((Number)Float.valueOf(pair[1]));
            array.add((JsonElement)pairArr);
        }
        return array;
    }

    private static float[][] deserializeWeek(JsonArray arr) {
        float[][] week = new float[arr == null ? 0 : arr.size()][2];
        if (arr == null) {
            return week;
        }
        for (int i = 0; i < arr.size(); ++i) {
            JsonElement e = arr.get(i);
            if (e == null || !e.isJsonArray()) {
                System.err.println("[ProjectAtmosphere] Warning: Week entry at index " + i + " is not an array. Defaulted to 0.");
                week[i][0] = 0.0f;
                week[i][1] = 0.0f;
                continue;
            }
            JsonArray pair = e.getAsJsonArray();
            week[i][0] = pair.size() > 0 && !pair.get(0).isJsonNull() ? ForecastDataStorage.getAsFloatSafe(pair.get(0)) : 0.0f;
            float f = week[i][1] = pair.size() > 1 && !pair.get(1).isJsonNull() ? ForecastDataStorage.getAsFloatSafe(pair.get(1)) : 0.0f;
            if (pair.size() >= 2) continue;
            System.err.println("[ProjectAtmosphere] Warning: Week entry at index " + i + " missing value(s). Defaulted to 0.");
        }
        return week;
    }

    private static float getAsFloatSafe(JsonElement e) {
        try {
            return e.getAsFloat();
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    private static JsonArray serializeWinds(WindVector[] winds) {
        JsonArray array = new JsonArray();
        if (winds == null) {
            return array;
        }
        for (WindVector wind : winds) {
            JsonObject obj = new JsonObject();
            obj.addProperty("speed", (Number)Float.valueOf(wind.baseSpeed()));
            obj.addProperty("angle", (Number)Float.valueOf(wind.angleRadians()));
            obj.addProperty("gustSpeed", (Number)Float.valueOf(wind.gustSpeed()));
            array.add((JsonElement)obj);
        }
        return array;
    }

    private static WindVector[] deserializeWinds(JsonArray arr) {
        WindVector[] winds = new WindVector[arr == null ? 0 : arr.size()];
        if (arr == null) {
            return winds;
        }
        for (int i = 0; i < arr.size(); ++i) {
            float gustSpeed;
            JsonElement e = arr.get(i);
            if (e == null || !e.isJsonObject()) {
                System.err.println("[ProjectAtmosphere] Warning: Wind entry at index " + i + " is not an object. Defaulted to zero wind.");
                winds[i] = new WindVector(0.0f, 0.0f, 0.0f);
                continue;
            }
            JsonObject obj = e.getAsJsonObject();
            float speed = obj.has("speed") && !obj.get("speed").isJsonNull() ? ForecastDataStorage.getAsFloatSafe(obj.get("speed")) : 0.0f;
            float angle = obj.has("angle") && !obj.get("angle").isJsonNull() ? ForecastDataStorage.getAsFloatSafe(obj.get("angle")) : 0.0f;
            float f = gustSpeed = obj.has("gustSpeed") && !obj.get("gustSpeed").isJsonNull() ? ForecastDataStorage.getAsFloatSafe(obj.get("gustSpeed")) : 0.0f;
            if (!(obj.has("speed") && obj.has("angle") && obj.has("gustSpeed"))) {
                System.err.println("[ProjectAtmosphere] Warning: Wind entry missing field(s) at index " + i + ". Defaulted to 0.");
            }
            winds[i] = new WindVector(speed, angle, gustSpeed);
        }
        return winds;
    }

    static {
        playerData = new ConcurrentHashMap<UUID, BlockPos>();
    }
}

