/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.manager;

import dev.nonamecrackers2.simpleclouds.common.cloud.SimpleCloudsConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.Gabou.projectatmosphere.ProjectAtmosphere;
import net.Gabou.projectatmosphere.async.BiomeSampler;
import net.Gabou.projectatmosphere.compat.CompatHandler;
import net.Gabou.projectatmosphere.compat.ToughAsNailsCompat;
import net.Gabou.projectatmosphere.manager.DailyForecastGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.manager.ForecastPointerRegistry;
import net.Gabou.projectatmosphere.modules.core.BiomeForecast;
import net.Gabou.projectatmosphere.modules.core.ForecastType;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.humidity.HumidityGenerator;
import net.Gabou.projectatmosphere.modules.pressure.PressureGenerator;
import net.Gabou.projectatmosphere.modules.storm.StormGenerator;
import net.Gabou.projectatmosphere.modules.temperature.spike.SpikeManager;
import net.Gabou.projectatmosphere.modules.temperature.util.TemperatureGenerator;
import net.Gabou.projectatmosphere.modules.temperature.variation.VariationGenerator;
import net.Gabou.projectatmosphere.modules.wind.WindGenerator;
import net.Gabou.projectatmosphere.modules.wind.WindMath;
import net.Gabou.projectatmosphere.network.BiomeDayTemperaturePacket;
import net.Gabou.projectatmosphere.util.AsyncAtmosphereService;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.neoforged.neoforge.network.PacketDistributor;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class ForecastGenerator {
    private static final int DIFFUSION_RADIUS = 200;
    private static final float DIFFUSION_RATE = 0.1f;
    private static final int SAMPLE_STEP = 128;
    private static BiomeInstanceKey scheduledStormBiome = null;
    private static long scheduledStormTime = -1L;
    static long seed = 0L;
    private static final float SANDSTORM_WIND_THRESHOLD_BASE = 10.0f;
    private static final float SANDSTORM_WIND_THRESHOLD_MIN = 6.0f;
    private static final float SANDSTORM_HUMIDITY_THRESHOLD_BASE = 20.0f;
    private static final float SANDSTORM_HUMIDITY_THRESHOLD_MAX = 35.0f;
    private static final float SANDSTORM_PRESSURE_THRESHOLD_BASE = 1005.0f;
    private static final float SANDSTORM_PRESSURE_THRESHOLD_MAX = 1015.0f;
    private static final boolean sandStormLoaded = CompatHandler.isSandStormsLoaded();
    public static final int MAX_POSITIONS_PER_BIOME;
    public static final Set<ResourceLocation> SANDSTORM_BIOMES;
    static final int RADIUS;
    static final Set<BiomeInstanceKey> biomeSamples;
    private static Map<ResourceLocation, List<BiomeInstanceKey>> biomeIndex;
    private static final Map<ResourceLocation, Integer> biomeSampleCounts;
    private static final Map<ResourceLocation, BiomeForecast> AVERAGE_FORECASTS;
    static final Map<BiomeInstanceKey, BiomeForecast> FORECAST_MAP;
    private static final Map<ResourceLocation, List<BiomeForecast>> grouped;
    private static final Map<BiomeInstanceKey, List<BiomeInstanceKey>> NEIGHBOR_CACHE;

    public static BiomeInstanceKey getScheduledSandstormBiome() {
        return scheduledStormBiome;
    }

    public static Map<ResourceLocation, List<BiomeInstanceKey>> getBiomeIndex() {
        return Collections.unmodifiableMap(biomeIndex);
    }

    public static void groupBiomeByType() {
        biomeIndex = biomeSamples.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType));
    }

    private static void computeAverageForecastsByBiomeType() {
        ForecastGenerator.computeAverageDaily();
    }

    private static void computeAllAverage() {
        HashMap<ResourceLocation, float[]> map = new HashMap<ResourceLocation, float[]>();
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
            avg.setPressureDay(ForecastGenerator.averageDay(list, BiomeForecast::getPressureDay));
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
            avg.setPressureTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getPressureTomorrow));
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
            avg.setTemperatureDay(ForecastGenerator.averageDay(list, BiomeForecast::getTemperatureDay));
            map.put(entry.getKey(), avg.getTemperatureDay());
            avg.setTemperatureTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getTemperatureTomorrow));
            avg.setBiomeKey(entry.getValue().get(0).getBiomeKey());
            avg.setStormChanceDay(ForecastGenerator.averageDay(list, BiomeForecast::getStormChanceDay));
            avg.setStormChanceTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getStormChanceTomorrow));
            avg.setWindDay(ForecastGenerator.averageWind(list, BiomeForecast::getWindDay));
            avg.setWindTomorrow(ForecastGenerator.averageWind(list, BiomeForecast::getWindTomorrow));
            avg.setHumidityDay(ForecastGenerator.averageDay(list, BiomeForecast::getHumidityDay));
            avg.setHumidityTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getHumidityTomorrow));
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BiomeDayTemperaturePacket(map), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void computeAverageDaily() {
        HashMap<ResourceLocation, float[]> map = new HashMap<ResourceLocation, float[]>();
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperatureDay(ForecastGenerator.averageDay(list, BiomeForecast::getTemperatureDay));
            map.put(entry.getKey(), avg.getTemperatureDay());
            avg.setTemperatureTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getTemperatureTomorrow));
            avg.setBiomeKey(entry.getValue().get(0).getBiomeKey());
            avg.setHumidityDay(ForecastGenerator.averageDay(list, BiomeForecast::getHumidityDay));
            avg.setHumidityTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getHumidityTomorrow));
            avg.setPressureDay(ForecastGenerator.averageDay(list, BiomeForecast::getPressureDay));
            avg.setPressureTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getPressureTomorrow));
            avg.setWindDay(ForecastGenerator.averageWind(list, BiomeForecast::getWindDay));
            avg.setWindTomorrow(ForecastGenerator.averageWind(list, BiomeForecast::getWindTomorrow));
            avg.setStormChanceDay(ForecastGenerator.averageDay(list, BiomeForecast::getStormChanceDay));
            avg.setStormChanceTomorrow(ForecastGenerator.averageDay(list, BiomeForecast::getStormChanceTomorrow));
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BiomeDayTemperaturePacket(map), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void computeAverageTemperatureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setTemperature(ForecastGenerator.averageWeek(list, BiomeForecast::getTemperature));
        }
    }

    private static void computeAverageHumidityWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setHumidity(ForecastGenerator.averageWeek(list, BiomeForecast::getHumidity));
        }
    }

    private static void computeAveragePressureWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setPressure(ForecastGenerator.averageWeek(list, BiomeForecast::getPressure));
        }
    }

    private static void computeAverageWindWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setWind(ForecastGenerator.averageWindWeek(list, BiomeForecast::getWind));
        }
    }

    private static void computeAverageStormChanceWeek() {
        for (Map.Entry<ResourceLocation, List<BiomeForecast>> entry : grouped.entrySet()) {
            List<BiomeForecast> list = entry.getValue();
            if (list.isEmpty()) continue;
            BiomeForecast avg = AVERAGE_FORECASTS.computeIfAbsent(entry.getKey(), k -> new BiomeForecast());
            avg.setStormChance(ForecastGenerator.averageWeek(list, BiomeForecast::getStormChance));
        }
    }

    public static void groupForecastsByBiome() {
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            ResourceLocation biomeType = entry.getKey().biomeType();
            grouped.computeIfAbsent(biomeType, k -> new ArrayList()).add(entry.getValue());
        }
    }

    private static float interpolate(float base, float minOrMax, float chanceMax) {
        float t = Mth.clamp((float)(chanceMax - 1.0f), (float)0.0f, (float)1.0f);
        return base - t * (base - minOrMax);
    }

    private static boolean shouldTriggerSandstorm(BiomeInstanceKey key, float[][] humidity, float[][] pressure, WindVector wind, float[] stormChance) {
        if (!SANDSTORM_BIOMES.contains(key.biomeType())) {
            return false;
        }
        if (stormChance == null || stormChance.length < 2) {
            return false;
        }
        float chanceMax = stormChance[1];
        float todayHumidityMin = humidity[0][0];
        float todayPressureMin = pressure[0][0];
        float windSpeed = wind.gustSpeed();
        float humidityThreshold = ForecastGenerator.interpolate(20.0f, 35.0f, chanceMax);
        float pressureThreshold = ForecastGenerator.interpolate(1005.0f, 1015.0f, chanceMax);
        float windThreshold = ForecastGenerator.interpolate(10.0f, 6.0f, chanceMax);
        boolean dryEnough = todayHumidityMin < humidityThreshold;
        boolean windyEnough = windSpeed > windThreshold;
        boolean unstablePressure = todayPressureMin < pressureThreshold;
        return dryEnough && windyEnough && unstablePressure;
    }

    public static BiomeForecast getAverageForecast(ResourceLocation biomeType) {
        return AVERAGE_FORECASTS.get(biomeType);
    }

    public static Set<BiomeInstanceKey> getBiomeSamples() {
        return biomeSamples;
    }

    static void clearBiomeSamples() {
        biomeSamples.clear();
        biomeIndex.clear();
    }

    static void generateForecastForSavedRegion(ServerLevel level) {
        ForecastGenerator.dailyAndSand(level);
    }

    private static void dailyAndSand(ServerLevel level) {
        DailyForecastGenerator.scheduleAll((Level)level, FORECAST_MAP);
        FORECAST_MAP.forEach(ForecastOrchestrator::generateWindForecast);
        ForecastGenerator.computeAverageForecastsByBiomeType();
        FORECAST_MAP.forEach(ForecastPointerRegistry::setPointer);
    }

    static void generateForecastForRegion(BlockPos center, ServerLevel level) {
        ResourceLocation biomeId;
        long start = System.nanoTime();
        long day = AsyncAtmosphereService.callOnMainThread(() -> level.getDayTime() / 24000L);
        Season season = AsyncAtmosphereService.callOnMainThread(() -> SeasonHelper.getSeasonState((Level)level).getSeason());
        BiomeSource biomeSource = AsyncAtmosphereService.callOnMainThread(() -> level.getChunkSource().getGenerator().getBiomeSource());
        BiomeSampler sampler = new BiomeSampler(ProjectAtmosphere.seed, level.registryAccess(), biomeSource);
        for (int dx = -RADIUS; dx <= RADIUS; dx += 128) {
            for (int dz = -RADIUS; dz <= RADIUS; dz += 128) {
                int count;
                BlockPos samplePos = center.offset(dx, 0, dz);
                biomeId = sampler.getBiomeId(samplePos.getX(), samplePos.getY(), samplePos.getZ());
                if (biomeId.getPath().contains("cave") || (count = biomeSampleCounts.getOrDefault(biomeId, 0).intValue()) >= MAX_POSITIONS_PER_BIOME) continue;
                biomeSamples.add(new BiomeInstanceKey(biomeId, samplePos));
                biomeSampleCounts.put(biomeId, count + 1);
            }
        }
        biomeIndex = biomeSamples.stream().collect(Collectors.groupingBy(BiomeInstanceKey::biomeType));
        if (CompatHandler.isToughAsNailsLoaded()) {
            Iterator<Map.Entry<BiomeInstanceKey, BiomeForecast>> processed = new HashSet();
            for (BiomeInstanceKey key : biomeSamples) {
                biomeId = key.biomeType();
                if (!processed.add((Map.Entry<BiomeInstanceKey, BiomeForecast>)biomeId)) continue;
                long sampleTime = System.currentTimeMillis();
                float[][] forecast = ToughAsNailsCompat.injectForecastForTAN(key, level);
                BiomeForecast bf = new BiomeForecast();
                bf.setTemperature(forecast);
                bf.setToughAsNailsFlag(true);
                bf.setBiomeKey(key);
                FORECAST_MAP.put(key, bf);
                long endTime = System.currentTimeMillis();
                ProjectAtmosphere.LOGGER.info("[Atmosphere] Tough as Nail forecast for " + String.valueOf(biomeId) + " at " + String.valueOf(key.samplePos()) + " took " + (endTime - sampleTime) + " ms");
            }
            ForecastGenerator.groupForecastsByBiome();
        } else {
            for (BiomeInstanceKey key : biomeSamples) {
                BiomeForecast forecast = new BiomeForecast();
                forecast.setTemperature(ForecastGenerator.generateTemperature(key, level));
                forecast.setBiomeKey(key);
                FORECAST_MAP.put(key, forecast);
            }
            ForecastGenerator.groupForecastsByBiome();
            ForecastGenerator.diffuseAndSmoothField(BiomeForecast::getTemperature, BiomeForecast::setTemperature);
        }
        ForecastGenerator.computeAverageTemperatureWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setHumidity(ForecastGenerator.generateHumidity(entry.getKey(), level, day));
        }
        ForecastGenerator.diffuseAndSmoothField(BiomeForecast::getHumidity, BiomeForecast::setHumidity);
        ForecastGenerator.computeAverageHumidityWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setPressure(ForecastGenerator.generatePressure(entry.getKey(), day));
        }
        ForecastGenerator.diffuseAndSmoothField(BiomeForecast::getPressure, BiomeForecast::setPressure);
        ForecastGenerator.computeAveragePressureWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setWind(ForecastGenerator.generateWind(entry.getKey()));
        }
        ForecastGenerator.computeAverageWindWeek();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            entry.getValue().setStormChance(ForecastGenerator.generateStorm(entry.getKey(), level, entry.getValue().getTemperature(), entry.getValue().getHumidity(), entry.getValue().getPressure(), entry.getValue().getWind(), season));
        }
        ForecastGenerator.computeAverageStormChanceWeek();
        ForecastGenerator.dailyAndSand(level);
        long end = System.nanoTime();
        long durationMs = (end - start) / 1000000L;
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Forecast region generation took " + durationMs + " ms.");
    }

    private static float[][] generateStorm(BiomeInstanceKey key, ServerLevel level, float[][] temperature, float[][] humidity, float[][] pressure, WindVector[] wind, Season season) {
        return StormGenerator.generateWeeklyStormProfile(key, temperature, humidity, pressure, wind, season);
    }

    private static float[][] generateTemperature(BiomeInstanceKey key, ServerLevel level) {
        return SpikeManager.applySpikeLogic(key, VariationGenerator.applyVariationToWeek(TemperatureGenerator.generateWeekForecast(level, key.samplePos(), key.biomeType())));
    }

    private static float[][] generateHumidity(BiomeInstanceKey key, ServerLevel level, Long day) {
        return HumidityGenerator.generateWeekForecast(level, key, day);
    }

    private static float[][] generatePressure(BiomeInstanceKey key, Long day) {
        return PressureGenerator.generateWeekForecast(key, day);
    }

    private static WindVector[] generateWind(BiomeInstanceKey key) {
        return WindGenerator.generateWindWeek(key);
    }

    public static Map<BiomeInstanceKey, BiomeForecast> getForecastMap() {
        return FORECAST_MAP;
    }

    private static void buildNeighborCache(Map<BiomeInstanceKey, float[][]> original, long threshold) {
        for (BiomeInstanceKey a : original.keySet()) {
            BlockPos pa = a.samplePos();
            ArrayList<BiomeInstanceKey> neighbors = new ArrayList<BiomeInstanceKey>();
            for (BiomeInstanceKey b : original.keySet()) {
                if (a == b || !(pa.distSqr((Vec3i)b.samplePos()) <= (double)threshold)) continue;
                neighbors.add(b);
            }
            NEIGHBOR_CACHE.put(a, neighbors);
        }
    }

    private static void diffuseAndSmoothField(Function<BiomeForecast, float[][]> getter, BiConsumer<BiomeForecast, float[][]> setter) {
        int i;
        long threshold = 40000L;
        HashMap<BiomeInstanceKey, float[][]> original = new HashMap<BiomeInstanceKey, float[][]>();
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            float[][] data = getter.apply(entry.getValue());
            if (data == null) continue;
            original.put(entry.getKey(), data);
        }
        if (NEIGHBOR_CACHE.isEmpty() || NEIGHBOR_CACHE.size() != original.size()) {
            ForecastGenerator.buildNeighborCache(original, threshold);
        }
        HashMap<BiomeInstanceKey, float[][]> diffused = new HashMap<BiomeInstanceKey, float[][]>();
        for (Map.Entry entry : original.entrySet()) {
            BiomeInstanceKey key = (BiomeInstanceKey)entry.getKey();
            float[][] week = (float[][])entry.getValue();
            List neighbors = NEIGHBOR_CACHE.getOrDefault(key, List.of());
            if (neighbors.isEmpty()) {
                diffused.put(key, week);
                continue;
            }
            float[][] smoothed = new float[7][2];
            for (int d = 0; d < 7; ++d) {
                for (i = 0; i < 2; ++i) {
                    float val = week[d][i];
                    float sum = 0.0f;
                    float count = 0.0f;
                    for (BiomeInstanceKey nKey : neighbors) {
                        float[][] n = (float[][])original.get(nKey);
                        sum += n[d][i];
                        count += 1.0f;
                    }
                    float avg = sum / count;
                    smoothed[d][i] = val + 0.1f * (avg - val);
                }
            }
            diffused.put(key, smoothed);
        }
        for (Map.Entry entry : diffused.entrySet()) {
            float[][] week = (float[][])entry.getValue();
            for (int d = 0; d < 7; ++d) {
                float[] prev = d > 0 ? week[d - 1] : week[d];
                float[] curr = week[d];
                float[] next = d < 6 ? week[d + 1] : week[d];
                for (i = 0; i < 2; ++i) {
                    curr[i] = (prev[i] + 2.0f * curr[i] + next[i]) / 4.0f;
                }
            }
            BiomeForecast forecast = FORECAST_MAP.get(entry.getKey());
            if (forecast == null) continue;
            setter.accept(forecast, week);
        }
    }

    static void clearForecasts() {
        FORECAST_MAP.clear();
        grouped.clear();
        biomeSamples.clear();
        biomeIndex.clear();
        biomeSampleCounts.clear();
        AVERAGE_FORECASTS.clear();
        scheduledStormBiome = null;
        scheduledStormTime = -1L;
        ForecastPointerRegistry.clear();
        ProjectAtmosphere.LOGGER.info("[Atmosphere] Cleared all forecasts and samples.");
    }

    static void putForecast(BiomeInstanceKey key, BiomeForecast forecast) {
        FORECAST_MAP.put(key, forecast);
        if (biomeSamples.add(key)) {
            biomeSampleCounts.put(key.biomeType(), biomeSampleCounts.getOrDefault(key.biomeType(), 0) + 1);
        }
    }

    static BiomeForecast getForecast(BiomeInstanceKey key) {
        return FORECAST_MAP.get(key);
    }

    static float getHumidityValue(BiomeInstanceKey key, long tick) {
        BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.HUMIDITY);
        if (forecast == null) {
            return 0.0f;
        }
        float[] curve = forecast.getHumidityDay();
        int minuteOfDay = (int)(tick % 24000L / 100L);
        if (curve == null) {
            return 50.0f;
        }
        return curve[Math.min(minuteOfDay, curve.length - 1)];
    }

    static float getTemperatureValue(BiomeInstanceKey key, long tick) {
        BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.TEMPERATURE);
        if (forecast == null) {
            return 0.0f;
        }
        float[] curve = forecast.getTemperatureDay();
        int minuteOfDay = (int)(tick % 24000L / 100L);
        if (curve == null) {
            return 0.0f;
        }
        return curve[Math.min(minuteOfDay, curve.length - 1)];
    }

    static float getStormChanceValue(BiomeInstanceKey key, long tick) {
        BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.STORM);
        if (forecast == null) {
            return 0.0f;
        }
        float[] curve = forecast.getStormChanceDay();
        int minuteOfDay = (int)(tick % 24000L / 100L);
        if (curve == null) {
            return 0.0f;
        }
        return curve[Math.min(minuteOfDay, curve.length - 1)];
    }

    static float getPressureValue(BiomeInstanceKey key, long tick) {
        BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.PRESSURE);
        if (forecast == null) {
            return 0.0f;
        }
        float[] curve = forecast.getPressureDay();
        int minuteOfDay = (int)(tick % 24000L / 100L);
        if (curve == null) {
            return 1013.0f;
        }
        return curve[Math.min(minuteOfDay, curve.length - 1)];
    }

    static WindVector getWindValue(BiomeInstanceKey key, long worldTime) {
        BiomeForecast forecast = ForecastGenerator.getClosestValidForecast(key, ForecastType.WIND);
        if (forecast == null) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        WindVector original = forecast.getWindDay();
        if (original == null) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        float speed = WindMath.getSmoothGustedSpeed(original, worldTime);
        return new WindVector(speed, original.angleRadians(), original.gustSpeed());
    }

    public static BiomeForecast getClosestValidForecast(BiomeInstanceKey key, ForecastType type) {
        if (key == null) {
            ProjectAtmosphere.LOGGER.warn("[Atmosphere] Requested forecast with null biome key for type {}", (Object)type);
            return ForecastGenerator.buildFallbackForecast(null);
        }
        BiomeForecast pointer = ForecastPointerRegistry.getPointer(key);
        if (pointer != null) {
            return pointer;
        }
        BiomeForecast average = ForecastGenerator.getAverageForecast(key.biomeType());
        if (average != null) {
            return average;
        }
        ProjectAtmosphere.LOGGER.warn("[Atmosphere] No forecast data available for {}. Returning fallback.", (Object)key);
        return ForecastGenerator.buildFallbackForecast(key);
    }

    private static BiomeForecast buildFallbackForecast(BiomeInstanceKey key) {
        BiomeForecast fallback = new BiomeForecast();
        fallback.setBiomeKey(key);
        fallback.setTemperature(new float[7][2]);
        fallback.setHumidity(new float[7][2]);
        fallback.setPressure(new float[7][2]);
        Object[] windWeek = new WindVector[7];
        Arrays.fill(windWeek, WindVector.fromBase(0.0f, 0.0f));
        fallback.setWind((WindVector[])windWeek);
        fallback.setWindDay(WindVector.fromBase(0.0f, 0.0f));
        return fallback;
    }

    static void swapToTomorrow() {
        for (Map.Entry<BiomeInstanceKey, BiomeForecast> entry : FORECAST_MAP.entrySet()) {
            BiomeForecast forecast = entry.getValue();
            forecast.setTemperature(ForecastGenerator.rotateWeek(forecast.getTemperature()));
            forecast.setHumidity(ForecastGenerator.rotateWeek(forecast.getHumidity()));
            forecast.setPressure(ForecastGenerator.rotateWeek(forecast.getPressure()));
            forecast.setStormChance(ForecastGenerator.rotateWeek(forecast.getStormChance()));
            forecast.setWind(ForecastGenerator.rotateWindWeek(forecast.getWind()));
            if (forecast.getTemperatureTomorrow() != null) {
                forecast.setTemperatureDay(forecast.getTemperatureTomorrow());
            }
            if (forecast.getHumidityTomorrow() != null) {
                forecast.setHumidityDay(forecast.getHumidityTomorrow());
            }
            if (forecast.getPressureTomorrow() != null) {
                forecast.setPressureDay(forecast.getPressureTomorrow());
            }
            if (forecast.getStormChanceTomorrow() != null) {
                forecast.setStormChanceDay(forecast.getStormChanceTomorrow());
            }
            if (forecast.getWindTomorrow() == null) continue;
            forecast.setWindDay(forecast.getWindTomorrow());
        }
        ForecastGenerator.computeAllAverage();
    }

    private static float[][] rotateWeek(float[][] original) {
        if (original == null || original.length < 2) {
            return original;
        }
        int len = original.length;
        float[][] rotated = new float[len][2];
        for (int i = 0; i < len - 1; ++i) {
            rotated[i] = original[i + 1];
        }
        rotated[len - 1] = new float[]{0.0f, 0.0f};
        return rotated;
    }

    private static WindVector[] rotateWindWeek(WindVector[] original) {
        if (original == null || original.length < 2) {
            return original;
        }
        int len = original.length;
        WindVector[] rotated = new WindVector[len];
        for (int i = 0; i < len - 1; ++i) {
            rotated[i] = original[i + 1];
        }
        rotated[len - 1] = WindVector.fromBase(0.0f, 0.0f);
        return rotated;
    }

    private static float[][] averageWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, float[][]> extractor) {
        int days = 7;
        int cols = 2;
        float[][] result = new float[days][cols];
        for (BiomeForecast f : forecasts) {
            float[][] data = extractor.apply(f);
            if (data == null) continue;
            for (int d = 0; d < days; ++d) {
                for (int c = 0; c < cols; ++c) {
                    float[] fArray = result[d];
                    int n = c;
                    fArray[n] = fArray[n] + data[d][c];
                }
            }
        }
        int size = forecasts.size();
        for (int d = 0; d < days; ++d) {
            int c = 0;
            while (c < cols) {
                float[] fArray = result[d];
                int n = c++;
                fArray[n] = fArray[n] / (float)size;
            }
        }
        return result;
    }

    private static float[] averageDay(List<BiomeForecast> forecasts, Function<BiomeForecast, float[]> extractor) {
        int size = forecasts.size();
        if (size == 0) {
            return new float[0];
        }
        int length = 240;
        float[] result = new float[length];
        for (BiomeForecast f : forecasts) {
            float[] curve = extractor.apply(f);
            if (curve == null || curve.length != length) continue;
            for (int i = 0; i < length; ++i) {
                int n = i;
                result[n] = result[n] + curve[i];
            }
        }
        int i = 0;
        while (i < length) {
            int n = i++;
            result[n] = result[n] / (float)size;
        }
        return result;
    }

    private static WindVector averageWind(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector> extractor) {
        if (forecasts.isEmpty()) {
            return WindVector.fromBase(0.0f, 0.0f);
        }
        float sumX = 0.0f;
        float sumZ = 0.0f;
        float sumGust = 0.0f;
        for (BiomeForecast f : forecasts) {
            WindVector wind = f.getWindDay();
            if (wind == null) continue;
            float angle = wind.angleRadians();
            float speed = wind.baseSpeed();
            sumX += speed * (float)Math.cos(angle);
            sumZ += speed * (float)Math.sin(angle);
            sumGust += wind.gustSpeed();
        }
        int size = forecasts.size();
        float avgX = sumX / (float)size;
        float avgZ = sumZ / (float)size;
        float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
        float avgAngle = (float)Math.atan2(avgZ, avgX);
        float avgGust = sumGust / (float)size;
        return new WindVector(avgSpeed, avgAngle, avgGust);
    }

    private static WindVector[] averageWindWeek(List<BiomeForecast> forecasts, Function<BiomeForecast, WindVector[]> extractor) {
        Object[] result = new WindVector[7];
        if (forecasts.isEmpty()) {
            Arrays.fill(result, WindVector.fromBase(0.0f, 0.0f));
            return result;
        }
        for (int day = 0; day < 7; ++day) {
            float sumX = 0.0f;
            float sumZ = 0.0f;
            float sumGust = 0.0f;
            int count = 0;
            for (BiomeForecast forecast : forecasts) {
                WindVector wind;
                WindVector[] windWeek = extractor.apply(forecast);
                if (windWeek == null || windWeek.length != 7 || (wind = windWeek[day]) == null) continue;
                float speed = wind.baseSpeed();
                float angle = wind.angleRadians();
                float gust = wind.gustSpeed();
                sumX += speed * (float)Math.cos(angle);
                sumZ += speed * (float)Math.sin(angle);
                sumGust += gust;
                ++count;
            }
            if (count > 0) {
                float avgX = sumX / (float)count;
                float avgZ = sumZ / (float)count;
                float avgSpeed = (float)Math.sqrt(avgX * avgX + avgZ * avgZ);
                float avgAngle = (float)Math.atan2(avgZ, avgX);
                float avgGust = sumGust / (float)count;
                result[day] = new WindVector(avgSpeed, avgAngle, avgGust);
                continue;
            }
            result[day] = WindVector.fromBase(0.0f, 0.0f);
        }
        return result;
    }

    static {
        SANDSTORM_BIOMES = Set.of(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"desert"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"badlands"));
        MAX_POSITIONS_PER_BIOME = CompatHandler.isToughAsNailsLoaded() ? 25 : 40;
        RADIUS = SimpleCloudsConstants.SPAWN_RADIUS;
        biomeSamples = ConcurrentHashMap.newKeySet();
        biomeIndex = new ConcurrentHashMap<ResourceLocation, List<BiomeInstanceKey>>();
        biomeSampleCounts = new ConcurrentHashMap<ResourceLocation, Integer>();
        AVERAGE_FORECASTS = new ConcurrentHashMap<ResourceLocation, BiomeForecast>();
        FORECAST_MAP = new ConcurrentHashMap<BiomeInstanceKey, BiomeForecast>();
        grouped = new ConcurrentHashMap<ResourceLocation, List<BiomeForecast>>();
        NEIGHBOR_CACHE = new ConcurrentHashMap<BiomeInstanceKey, List<BiomeInstanceKey>>();
    }
}

