/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.compat.SimpleCloudsCompat;
import net.Gabou.projectatmosphere.data.TornadoStorageManager;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.temperature.command.TemperatureCommandHelper;
import net.Gabou.projectatmosphere.modules.tornado.TornadoProbabilityManager;
import net.Gabou.projectatmosphere.modules.tornado.TornadoSpawner;
import net.Gabou.projectatmosphere.util.AtmosphereUtils;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public final class TornadoDebug {
    private TornadoDebug() {
    }

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"weatherdebug").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"cloud").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Cloud spawning is only available in the Overworld."));
                return 0;
            }
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.blockPosition());
            WindVectorApi.WindSample sample = WindVectorApi.getOrFallback(key);
            WindVector wind = WindVector.fromBase(sample.speedMps(), (float)Math.toRadians(sample.directionDeg()));
            String cloudId = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            CloudRegion region = SimpleCloudsCompat.spawnCloudInBiome(cloudId, key, level, null, wind);
            if (region != null) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Spawned cloud '" + cloudId + "' at your position.")), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Failed to spawn cloud '" + cloudId + "'. SimpleClouds may not be initialized yet.")));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tornado").then(Commands.literal((String)"risk").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Tornado risk is only available in the Overworld."));
                return 0;
            }
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.blockPosition());
            float risk = TornadoProbabilityManager.computeRisk(key, level, level.getGameTime());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Risk: " + risk)), false);
            return 1;
        }))).then(Commands.literal((String)"force").then(Commands.argument((String)"intensity", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Tornado spawning is only available in the Overworld."));
                return 0;
            }
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.blockPosition());
            float intensity = FloatArgumentType.getFloat((CommandContext)ctx, (String)"intensity");
            TornadoSpawner.spawn(key, level, intensity);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Tornado spawned."), true);
            return 1;
        })))).then(Commands.literal((String)"cooldown").then(Commands.literal((String)"reset").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerLevel level = player.serverLevel();
            if (!TemperatureCommandHelper.isInOverworld((Level)level)) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Tornado cooldown reset is only available in the Overworld."));
                return 0;
            }
            BiomeInstanceKey key = AtmosphereUtils.getBiomeKey(level, player.blockPosition());
            TornadoStorageManager.setCooldown(key, 0L);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Cooldown cleared."), true);
            return 1;
        })))));
    }
}

