/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.projectatmosphere.modules.tornado;

import net.Gabou.projectatmosphere.api.WindVectorApi;
import net.Gabou.projectatmosphere.config.AtmoCommonConfig;
import net.Gabou.projectatmosphere.modules.core.WindVector;
import net.Gabou.projectatmosphere.modules.tornado.TornadoManager;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public final class TornadoSpawner {
    private TornadoSpawner() {
    }

    public static void spawn(BiomeInstanceKey key, ServerLevel level, float intensity) {
        float radiusSetting = ((Double)AtmoCommonConfig.TORNADO_BASE_SPAWN_RADIUS_M.get()).floatValue();
        BlockPos center = TornadoSpawner.pickSpawnPosNear(key, level, radiusSetting);
        WindVectorApi.WindSample wind = WindVectorApi.getSurface(key);
        float radius = 5.0f + 20.0f * intensity;
        WindVector w = WindVector.fromBase(wind.speedMps(), (float)Math.toRadians(wind.directionDeg()));
        TornadoManager.spawnServer(level, Vec3.atCenterOf((Vec3i)center), radius, w);
    }

    private static BlockPos pickSpawnPosNear(BiomeInstanceKey key, ServerLevel level, float radius) {
        BlockPos base = key.samplePos();
        int r = (int)radius;
        int dx = level.random.nextInt(-r, r + 1);
        int dz = level.random.nextInt(-r, r + 1);
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, base.getX() + dx, base.getZ() + dz);
        return new BlockPos(base.getX() + dx, y, base.getZ() + dz);
    }
}

